// main.js

const { app, BrowserWindow } = require('electron');

const path = require('path');



function toggleContent() {

  const content = document.getElementById('content');

  content.style.display = (content.style.display === 'none') ? 'flex' : 'none';

}



//document.getElementById('content').style.display = 'none';



function createWindow() {

  const win = new BrowserWindow({

    width: 1280,

    height: 800,

    resizable: true,

    webPreferences: {

      preload: path.join(__dirname, 'preload.js'),

    },

    icon: path.join(__dirname, 'public', 'icon.png'),

  });



  win.loadFile(path.join(__dirname, 'public', 'index.html'));

}



app.whenReady().then(() => {

  createWindow();



  app.on('activate', () => {

    if (BrowserWindow.getAllWindows().length === 0) createWindow();

  });

});



app.on('window-all-closed', () => {

  if (process.platform !== 'darwin') app.quit();

});

