<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Storico Utente</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap @5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { padding: 20px; background-color: #f8f9fa; }
        table { margin-top: 20px; }
        h1 { margin-bottom: 30px; }
    </style>
</head>
<body>
<div class="container">
    <h1>Storico Noleggi dell'Utente</h1>
    <?php
    if (!isset($_GET['email']) || empty($_GET['email'])) {
        echo "<div class='alert alert-danger'>Email utente non fornita o non valida.</div>";
        exit();
    }

    $email = trim($_GET['email']); // Rimuove spazi vuoti dall'email

    // Query per ottenere lo storico dell'utente
    $stmt = $conn->prepare("SELECT r.id AS rental_id, d.codice, d.numero_inventario, d.ubicazione, r.rental_start, r.rental_end 
                            FROM rentals r
                            JOIN device d ON r.device_code = d.codice
                            JOIN users u ON r.user_id = u.id
                            WHERE u.email = ?");
    if (!$stmt) {
        die("Errore nella preparazione della query: " . htmlspecialchars($conn->error));
    }

    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo "<table class='table table-bordered table-striped'>
                <thead class='table-light'>
                <tr>
                    <th>ID Noleggio</th><th>Codice</th><th>Dispositivo (Numero Inventario)</th><th>Ubicazione</th><th>Inizio</th><th>Fine</th>
                </tr>
                </thead>
                <tbody>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>
                    <td>{$row['rental_id']}</td>
                    <td>{$row['codice']}</td>
                    <td>{$row['numero_inventario']}</td>
                    <td>{$row['ubicazione']}</td>
                    <td>" . htmlspecialchars($row['rental_start']) . "</td>
                    <td>" . ($row['rental_end'] ? htmlspecialchars($row['rental_end']) : '<span class="text-danger">Ancora attivo</span>') . "</td>
                  </tr>";
        }
        echo "</tbody></table>";
    } else {
        echo "<div class='alert alert-warning'>Nessun noleggio trovato per questo utente.</div>";
    }

    $stmt->close(); // Chiude la query preparata
    ?>
    <a href="index.php" class="btn btn-secondary mt-3">⬅ Torna alla Home</a>
</div>
</body>
</html>