<?php
// Abilita il debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Connessione al database
$conn = new mysqli("localhost", "root", "", "noleggi");
if ($conn->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Connessione fallita: ' . $conn->connect_error]));
}

// Ricevi i dati dal client
$data = json_decode(file_get_contents('php://input'), true);
if (!$data) {
    die(json_encode(['success' => false, 'message' => 'Dati non ricevuti']));
}

$softwareId = $data['softwareId'];
$visorIds = $data['visorIds'];

// Inserisci l'assegnazione nel database per ogni visore selezionato
$sql = "INSERT INTO elencosoftwarevr (visore_id, software_id, data_installazione) VALUES (?, ?, CURDATE())";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    die(json_encode(['success' => false, 'message' => 'Errore nella preparazione della query: ' . $conn->error]));
}

$success = true;
foreach ($visorIds as $visorId) {
    $stmt->bind_param("si", $visorId, $softwareId);
    if (!$stmt->execute()) {
        $success = false;
        break;
    }
}

if ($success) {
    echo json_encode(['success' => true, 'message' => 'Software assegnato con successo']);
} else {
    echo json_encode(['success' => false, 'message' => 'Errore durante l\'assegnazione: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>