<?php
// Includi il file di configurazione del database
require_once 'db.php';

// Variabili per i messaggi di feedback
$message = '';
$success = false;

// Gestione della registrazione
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Raccolta e sanificazione dei dati
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Validazione dei campi
    if (empty($name) || empty($email) || empty($password)) {
        $message = 'Tutti i campi sono obbligatori.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = 'Inserisci un indirizzo email valido.';
    } else {
        // Verifica se l'email è già registrata
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $message = 'L\'email è già registrata.';
        } else {
            // Hash della password
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

            // Inserimento dei dati nel database
            $insertStmt = $conn->prepare("INSERT INTO users (name, email, password, ruolo) VALUES (?, ?, ?, 'UTENTE')");
            $insertStmt->bind_param('sss', $name, $email, $hashedPassword);

            if ($insertStmt->execute()) {
                $message = 'Registrazione completata con successo!';
                $success = true;
            } else {
                $message = 'Errore durante la registrazione. Riprova più tardi.';
            }

            $insertStmt->close();
        }

        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrazione Utente</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .register-container {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            width: 300px;
        }
        .register-container h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .form-group input {
            width: 100%;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .form-group button {
            width: 100%;
            padding: 10px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .form-group button:hover {
            background-color: #218838;
        }
        .message {
            text-align: center;
            margin-top: 15px;
            font-weight: bold;
        }
        .message.success {
            color: green;
        }
        .message.error {
            color: red;
        }
    </style>
</head>
<body>
    <div class="register-container">
        <h2>Registrazione</h2>
        <?php if ($message): ?>
            <div class="message <?php echo $success ? 'success' : 'error'; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        <form method="POST" action="">
            <div class="form-group">
                <label for="name">Nome</label>
                <input type="text" id="name" name="name" required />
            </div>
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" required />
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required />
            </div>
            <div class="form-group">
                <button type="submit">Registrati</button>
            </div>
        </form>
    </div>
</body>
</html>

<?php
// Chiudi la connessione al database
$conn->close();
?>