<?php
session_start();
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['uid'])) {
    $uid = trim($_POST['uid']);

    // Normalizza UID (rimuovi spazi e caratteri non validi)
    $uid = preg_replace('/[^a-zA-Z0-9]/', '', $uid);

    // Cerca il device associato
    $stmt = $conn->prepare("SELECT codice FROM device WHERE uidisp = ?");
    $stmt->bind_param("s", $uid);
    $stmt->execute();
    $stmt->bind_result($codice);
    if ($stmt->fetch()) {
        // Aggiunge il device a sessione
        $_SESSION['step'] = 1;
        $_SESSION['noleggio_devices'] = [$codice];
        $_SESSION['message'] = "Dispositivo $codice (UID: $uid) rilevato. Seleziona un utente per completare il noleggio.";
    } else {
        $_SESSION['message'] = "Nessun dispositivo trovato per UID: $uid";
    }
    $stmt->close();
} else {
    $_SESSION['message'] = "UID non ricevuto correttamente.";
}

header("Location: noleggi.php");
exit();
