<?php
include 'db.php';

// Ricevi gli UID dal POST
$uids = isset($_POST['uids']) ? trim($_POST['uids']) : '';

if (empty($uids)) {
    echo json_encode(['success' => false, 'message' => 'UID mancante']);
    exit;
}

$uidArray = explode(",", $uids);

// Recupera i device_name associati agli UID
$devices = [];
foreach ($uidArray as $uid) {
    $stmt = $conn->prepare("SELECT device_name FROM uidisp WHERE uid = ?");
    $stmt->bind_param("s", $uid);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $devices[] = $row['device_name'];
    }
}

if (empty($devices)) {
    echo json_encode(['success' => false, 'message' => 'Nessun dispositivo trovato']);
    exit;
}

// Crea sempre un nuovo ordine con i nomi dei dispositivi
$devicesString = implode(",", $devices);

$insertStmt = $conn->prepare("INSERT INTO rental_orders (devices, status) VALUES (?, 'IN_PROGRESS')");
$insertStmt->bind_param("s", $devicesString);
$insertStmt->execute();

if ($insertStmt->affected_rows > 0) {
    // Restituisci i nomi dei dispositivi al client
    echo json_encode([
        'success' => true,
        'message' => 'Nuovo ordine creato con successo',
        'devices' => $devices
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Errore durante la creazione dell\'ordine']);
}

// Chiudi le connessioni
$insertStmt->close();
$conn->close();
?>