<?php
// completa_ordine.php
include 'db.php';

// Recupera tutti gli ordini IN_PROGRESS
$ordini = [];
$stmt = $conn->prepare("SELECT id, devices FROM rental_orders WHERE status = 'IN_PROGRESS'");
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $ordini[] = $row;
}
$stmt->close();

// Recupera tutti gli utenti
$utenti = [];
$stmt = $conn->prepare("SELECT id, name FROM users");
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $utenti[] = $row;
}
$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Completa Ordine</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        label { display: block; margin-top: 10px; }
        select, button { padding: 5px; margin-top: 5px; }
    </style>
</head>
<body>

    <h2>Completa un Ordine</h2>

    <form id="completaForm" method="GET" action="noleggi.php">
        <label for="ordine">Seleziona Ordine:</label>
        <select id="ordine" name="ordine" required onchange="updateComment()">
            <option value="">-- Scegli un ordine --</option>
            <?php foreach ($ordini as $ordine): ?>
                <option value="<?= htmlspecialchars($ordine['devices']) ?>">
                    Ordine #<?= $ordine['id'] ?> - <?= htmlspecialchars($ordine['devices']) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <label for="user">Seleziona Utente:</label>
        <select id="user" name="user" required>
            <option value="">-- Scegli un utente --</option>
            <?php foreach ($utenti as $utente): ?>
                <option value="<?= $utente['id'] ?>"><?= htmlspecialchars($utente['name']) ?></option>
            <?php endforeach; ?>
        </select>

        <input type="hidden" name="comment" id="comment">

        <button type="submit" style="margin-top: 20px;">Completa Ordine</button>
    </form>

    <script>
        function updateComment() {
            const ordineSelect = document.getElementById('ordine');
            const commentInput = document.getElementById('comment');
            if (ordineSelect.value) {
                // Trasforma device1,device2 in device1>device2
                const formatted = ordineSelect.value.split(',').join('>');
                commentInput.value = formatted;
            } else {
                commentInput.value = '';
            }
        }
    </script>

</body>
</html>
