<?php
include 'db.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
if (!isset($input['uid'])) {
    echo json_encode(['errore' => 'UID mancante']);
    exit;
}

$uid = $conn->real_escape_string($input['uid']);
$sql = "SELECT device_name FROM uidsip WHERE uid = '$uid' LIMIT 1";
$result = $conn->query($sql);

if ($result && $row = $result->fetch_assoc()) {
    echo json_encode(['device_name' => $row['device_name']]);
} else {
    echo json_encode(['errore' => 'UID non trovato']);
}

?>

<!DOCTYPE html>
<html lang="it">
<head>
  <meta charset="UTF-8">
  <title>Lettore NFC - Noleggi</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: linear-gradient(to bottom right, #e0f7fa, #ffffff);
      text-align: center;
      padding: 40px;
      margin: 0;
    }

    .container {
      background: white;
      border-radius: 16px;
      box-shadow: 0 4px 20px rgba(0,0,0,0.1);
      padding: 40px;
      display: inline-block;
      min-width: 320px;
      max-width: 600px;
      margin-top: 30px;
    }

    h1 {
      color: #00796b;
      margin-bottom: 20px;
    }

    button, select {
      padding: 10px 20px;
      font-size: 16px;
      margin: 10px 0;
      border-radius: 6px;
      border: none;
      cursor: pointer;
    }

    button {
      background-color: #00796b;
      color: white;
    }

    select {
      background-color: #f5f5f5;
      border: 1px solid #ccc;
    }

    p {
      font-size: 18px;
      margin: 10px 0;
    }

    #device {
      font-weight: bold;
      color: green;
    }

    #errore {
      color: red;
      font-size: 14px;
    }

    @media (max-width: 600px) {
      .container {
        width: 90%;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>Lettore NFC – Noleggi</h1>
    <p>Seleziona la porta seriale:</p>
    <button onclick="scegliPorta()">📡 Scegli Porta</button>
    <p id="portaScelta">Nessuna porta selezionata</p>
    <button onclick="connetti()">🔌 Connetti</button>
    <p id="stato">Stato: Non connesso</p>
    <p id="uid">UID: -</p>
    <p id="device">Device: -</p>
    <p id="errore"></p>
  </div>

  <script>
    let porta;
    let lettore;

    async function scegliPorta() {
      try {
        porta = await navigator.serial.requestPort();
        document.getElementById("portaScelta").innerText = "Porta selezionata!";
        document.getElementById("errore").innerText = "";
      } catch (err) {
        document.getElementById("errore").innerText = "Errore selezione porta: " + err;
      }
    }

    async function connetti() {
      if (!porta) {
        document.getElementById("errore").innerText = "Seleziona prima una porta.";
        return;
      }

      try {
        await porta.open({ baudRate: 9600 });
        document.getElementById("stato").innerText = "Stato: Connesso";
        lettore = porta.readable.getReader();
        leggiSeriale();
      } catch (e) {
        document.getElementById("stato").innerText = "Errore connessione: " + e;
      }
    }

    async function leggiSeriale() {
      let buffer = "";

      while (true) {
        try {
          const { value, done } = await lettore.read();
          if (done) break;

          buffer += new TextDecoder().decode(value);

          if (buffer.includes("\n")) {
            const righe = buffer.split("\n");
            for (let i = 0; i < righe.length - 1; i++) {
              const riga = righe[i].trim();
              if (riga.startsWith("UID:")) {
                const uid = riga.replace("UID:", "").trim();
                document.getElementById("uid").innerText = "UID: " + uid;
                cercaDevice(uid);
              }
            }
            buffer = righe[righe.length - 1];
          }
        } catch (e) {
          document.getElementById("stato").innerText = "Errore lettura: " + e;
          break;
        }
      }

      lettore.releaseLock();
    }

    function cercaDevice(uid) {
      fetch("db.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ uid })
      })
      .then(res => res.json())
      .then(data => {
        if (data.device_name) {
          document.getElementById("device").innerText = "Device: " + data.device_name;
        } else {
          document.getElementById("device").innerText = "Device: non registrato";
        }
      })
      .catch(err => {
        document.getElementById("device").innerText = "Errore comunicazione col server";
      });
    }
  </script>
</body>
</html>
