<?php
// FILE: noleggio_da_qr.php
include 'db.php';
require 'fpdf/fpdf.php';
session_start();

$email = $_GET['email'] ?? '';
$user_id = 0;
$user_name = '';
$signaturePath = '';

if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $stmt = $conn->prepare("SELECT id, name FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->bind_result($user_id, $user_name);
    $stmt->fetch();
    $stmt->close();
    $signaturePath = 'firme_utente/firma_' . md5($email) . '.png';
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['conferma_noleggio'])) {
    $device_codes = $_POST['device_codes'] ?? [];
    $email = $_POST['email'] ?? '';
    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $stmt = $conn->prepare("SELECT id, name FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->bind_result($user_id, $user_name);
        $stmt->fetch();
        $stmt->close();
        $signaturePath = 'firme_utente/firma_' . md5($email) . '.png';
    }
    if ($user_id && count($device_codes) > 0) {
        $rental_start = date('Y-m-d H:i:s');

        $stmt = $conn->prepare("INSERT INTO rentals (device_code, user_id, rental_start) VALUES (?, ?, ?)");
        $stmt->bind_param("sis", $code, $user_id, $rental_start);

        foreach ($device_codes as $code) {
            $stmt->execute();
        }
        $stmt->close();

        if (!is_dir('noleggi_pdf')) mkdir('noleggi_pdf', 0777, true);

        $pdf = new FPDF();
        $pdf->AddPage();
        $pdf->SetFont('Arial','B',14);
        $pdf->Cell(0, 10, 'Riepilogo Noleggio', 0, 1, 'C');
        $pdf->Ln(5);
        $pdf->SetFont('Arial','',12);
        $pdf->Cell(0, 10, "Utente: $user_name ($email)", 0, 1);
        $pdf->Cell(0, 10, "Data inizio noleggio: $rental_start", 0, 1);
        $pdf->Ln(5);
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(60, 10, 'Codice Dispositivo', 1);
        $pdf->Cell(60, 10, 'Inventario', 1);
        $pdf->Ln();
        $pdf->SetFont('Arial','',12);

        foreach ($device_codes as $code) {
            $deviceQ = $conn->prepare("SELECT numero_inventario FROM device WHERE codice = ?");
            $deviceQ->bind_param("s", $code);
            $deviceQ->execute();
            $deviceQ->bind_result($inv_num);
            $deviceQ->fetch();
            $deviceQ->close();

            $pdf->Cell(60, 10, $code, 1);
            $pdf->Cell(60, 10, $inv_num, 1);
            $pdf->Ln();
        }

        $pdf->Ln(10);
        $pdf->SetFont('Arial', '', 11);
        $pdf->MultiCell(0, 8, "Con la presente, l'utente si assume ogni responsabilita' relativa all'utilizzo e restituzione dell'attrezzatura noleggiata.");
        $pdf->Ln(10);
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(90, 10, "Firma Cliente", 0, 0);

        $y = $pdf->GetY();
        if (file_exists($signaturePath)) {
            $pdf->Image($signaturePath, 10, $y + 10, 60);
        }

        $pdfname = 'noleggio_' . md5($email . time()) . '.pdf';
        $pdfpath = 'noleggi_pdf/' . $pdfname;
        $pdf->Output('F', $pdfpath);

        $_SESSION['message'] = "Noleggio completato. <a href='$pdfpath' class='btn btn-sm btn-outline-primary' target='_blank'>Scarica PDF</a>";
    } else {
        $_SESSION['message'] = "Dati mancanti o dispositivi non selezionati.";
    }
    header("Location: noleggio_da_qr.php?email=" . urlencode($email));
    exit();
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Noleggio da QR</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    <style>
        body {
            background-color: #f0f2f5;
            font-family: 'Segoe UI', Tahoma, sans-serif;
            padding-bottom: 70px;
        }

        .container {
            margin-top: 40px;
            max-width: 720px;
        }

        .card {
            border-radius: 1rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            padding: 2rem;
            background: white;
        }

        #qr-reader {
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.2);
            overflow: hidden;
            margin-bottom: 20px;
        }

        select[multiple] {
            border-radius: 0.5rem;
        }

        img.signature-preview {
            border: 1px solid #ccc;
            border-radius: 8px;
            margin-top: 10px;
        }

        footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: white;
            color: #555;
            font-size: 0.9rem;
            text-align: center;
            padding: 0.75rem 0;
            box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
            z-index: 1000;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="card">
        <h2 class="mb-3 text-center">Noleggio da QR Code</h2>

        <div class="mb-3">
            <label for="camera-select" class="form-label">Scegli fotocamera:</label>
            <select id="camera-select" class="form-select mb-2"></select>
        </div>

        <div id="qr-reader" style="width:100%"></div>

        <script>
        let html5QrCode;
        let selectedCameraId = null;

        function onScanSuccess(decodedText) {
            if (decodedText.includes('@')) {
                window.location.href = "noleggio_da_qr.php?email=" + encodeURIComponent(decodedText);
            }
        }

        function startScanner(cameraId) {
            if (html5QrCode) {
                html5QrCode.stop().then(() => {
                    html5QrCode.clear();
                    html5QrCode.start(cameraId, { fps: 10, qrbox: 250 }, onScanSuccess);
                });
            } else {
                html5QrCode = new Html5Qrcode("qr-reader");
                html5QrCode.start(cameraId, { fps: 10, qrbox: 250 }, onScanSuccess);
            }
        }

        Html5Qrcode.getCameras().then(cameras => {
            const cameraSelect = document.getElementById("camera-select");
            cameras.forEach(camera => {
                const option = document.createElement("option");
                option.value = camera.id;
                option.text = camera.label || camera.id;
                cameraSelect.appendChild(option);
            });

            if (cameras.length > 0) {
                selectedCameraId = cameras[0].id;
                startScanner(selectedCameraId);
            }

            cameraSelect.addEventListener("change", () => {
                selectedCameraId = cameraSelect.value;
                startScanner(selectedCameraId);
            });
        });
        </script>

        <?php if ($user_id): ?>
        <div class="mt-4">
            <h5>Utente: <strong><?= htmlspecialchars($user_name) ?></strong> (<?= htmlspecialchars($email) ?>)</h5>

            <?php if (isset($_SESSION['message'])): ?>
                <div class="alert alert-info mt-3"><?= $_SESSION['message']; unset($_SESSION['message']); ?></div>
            <?php endif; ?>

            <div class="mb-3">
                <label class="form-label">Firma salvata:</label><br>
                <img src="<?= $signaturePath ?>" width="300" class="signature-preview" />
            </div>

            <form method="post">
                <input type="hidden" name="conferma_noleggio" value="1">
                <input type="hidden" name="email" value="<?= htmlspecialchars($email) ?>">
                <div class="mb-3">
                    <label for="device_codes" class="form-label">Seleziona dispositivi disponibili:</label>
                    <select name="device_codes[]" multiple class="form-select" size="6" required>
                        <?php
                        $devs = $conn->query("SELECT codice, numero_inventario FROM device WHERE stato = 'FUNZIONANTE' AND codice NOT IN (SELECT device_code FROM rentals WHERE rental_end IS NULL) ORDER BY codice");
                        while ($d = $devs->fetch_assoc()) {
                            echo "<option value='{$d['codice']}'>{$d['codice']} - {$d['numero_inventario']}</option>";
                        }
                        ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-success w-100">Conferma Noleggio</button>
            </form>
        </div>
        <?php endif; ?>
    </div>
</div>

<footer>
    Realizzato per il <strong>Laboratorio Classroom Enrico Fermi</strong> da <strong>Ricchiuto Michele 4CI</strong>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
