<?php
session_start();

// Includi il file di configurazione del database
require_once 'db.php';

// Variabile messaggio
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    if (empty($email) || empty($password)) {
        $message = 'Inserisci email e password.';
    } else {
        $stmt = $conn->prepare("SELECT id, name, password FROM users WHERE email = ?");
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $stmt->bind_result($user_id, $user_name, $hashed_password);
            $stmt->fetch();

            if (password_verify($password, $hashed_password)) {
                $_SESSION['user_id'] = $user_id;
                $_SESSION['user_name'] = $user_name;
                header('Location: dashboard.php');
                exit;
            } else {
                $message = 'Email o password non validi.';
            }
        } else {
            $message = 'Email o password non validi.';
        }

        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Login</title>
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #2980b9;
            --bg-color: #ecf0f1;
            --white: #ffffff;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--bg-color);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .login-container {
            background: var(--white);
            padding: 30px 30px 40px;
            border-radius: 12px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.15);
            width: 100%;
            max-width: 360px;
            box-sizing: border-box;
            text-align: center;
        }

        .login-container img {
            max-width: 100px;
            margin-bottom: 20px;
        }

        h2 {
            color: var(--primary-color);
            margin-bottom: 20px;
        }

        .form-group {
            text-align: left;
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 6px;
            font-weight: bold;
            color: var(--primary-color);
        }

        input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 14px;
            box-sizing: border-box;
        }

        button {
            width: 100%;
            padding: 12px;
            background-color: var(--secondary-color);
            color: var(--white);
            font-weight: bold;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            margin-top: 10px;
        }

        button:hover {
            background-color: #206ea2;
        }

        .message {
            margin-top: 15px;
            font-weight: bold;
            color: red;
        }

        @media (max-width: 400px) {
            .login-container {
                margin: 0 20px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <img src="logo_fermi.png" alt="Logo Istituto Fermi" />
        <h2>Login</h2>

        <?php if ($message): ?>
            <div class="message"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" name="email" id="email" required autofocus />
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" name="password" id="password" required />
            </div>
            <button type="submit">Accedi</button>
        </form>
    </div>
</body>
</html>
<?php $conn->close(); ?>
