<?php
include 'db.php';

// Ricevi l'UID dal GET
$uid = isset($_GET['uid']) ? trim($_GET['uid']) : '';

if (empty($uid)) {
    echo json_encode(['success' => false, 'message' => 'UID mancante']);
    exit;
}

// Recupera il device_name associato all'UID
$stmt = $conn->prepare("SELECT device_name FROM uidisp WHERE uid = ?");
$stmt->bind_param("s", $uid);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo json_encode(['success' => true, 'device_name' => $row['device_name']]);
} else {
    echo json_encode(['success' => false, 'message' => 'Dispositivo non trovato']);
}

$stmt->close();
$conn->close();
?>