<?php
session_start();

// Includi il file di configurazione del database
require_once 'db.php';

// Variabili per i messaggi di feedback
$message = '';

// Gestione della modifica della password
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Raccolta e sanificazione dei dati
    $email = trim($_POST['email']);

    // Validazione dell'email
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = 'Inserisci un indirizzo email valido.';
    } else {
        // Query per recuperare l'utente dal database
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            // Imposta la nuova password di default
            $defaultPassword = 'fermi2025';
            $hashedPassword = password_hash($defaultPassword, PASSWORD_DEFAULT);

            // Aggiorna la password nel database
            $updateStmt = $conn->prepare("UPDATE users SET password = ? WHERE email = ?");
            $updateStmt->bind_param('ss', $hashedPassword, $email);

            if ($updateStmt->execute()) {
                $message = "La password è stata reimpostata correttamente. Nuova password: <strong>$defaultPassword</strong>";
            } else {
                $message = 'Errore durante l\'aggiornamento della password. Riprova più tardi.';
            }

            $updateStmt->close();
        } else {
            $message = 'Nessun utente trovato con questa email.';
        }

        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Modifica Password</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            width: 300px;
        }
        .container h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .form-group input {
            width: 100%;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .form-group button {
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .form-group button:hover {
            background-color: #0056b3;
        }
        .message {
            text-align: center;
            margin-top: 15px;
            font-weight: bold;
        }
        .message.success {
            color: green;
        }
        .message.error {
            color: red;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Modifica Password</h2>
        <?php if ($message): ?>
            <div class="message <?php echo strpos($message, 'errore') !== false ? 'error' : 'success'; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>
        <form method="POST" action="">
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" required />
            </div>
            <div class="form-group">
                <button type="submit">Reimposta Password</button>
            </div>
        </form>
    </div>
</body>
</html>

<?php
// Chiudi la connessione al database
$conn->close();
?>