<?php
// Imposta il tipo di contenuto per il download
header('Content-Type: application/pdf');

// Ottieni i parametri dalla query string
$type = $_GET['type'] ?? ''; // 'noleggio' o 'restituzione'
$id = $_GET['id'] ?? '';

// Definisci i percorsi delle cartelle
$noleggi_pdf_path = __DIR__ . '/noleggi_pdf/';
$restituzioni_pdf_path = __DIR__ . '/restituzioni_pdf/';

// Funzione per trovare il file PDF in base all'id
function findPdfFile($folderPath, $id) {
    // Scansiona la cartella per trovare i file PDF
    if (!is_dir($folderPath)) {
        return null;
    }

    $files = scandir($folderPath);
    foreach ($files as $file) {
        if (pathinfo($file, PATHINFO_EXTENSION) === 'pdf') {
            // Estrai l'id dal nome del file
            if (preg_match('/_(\d+)\.pdf$/', $file, $matches)) {
                $fileId = $matches[1];
                if ($fileId == $id) {
                    return $file;
                }
            }
        }
    }

    return null;
}

// Trova il file PDF in base al tipo e all'id
if ($type === 'noleggio') {
    $file_name = findPdfFile($noleggi_pdf_path, $id);
    $file_path = $noleggi_pdf_path . $file_name;
} elseif ($type === 'restituzione') {
    $file_name = findPdfFile($restituzioni_pdf_path, $id);
    $file_path = $restituzioni_pdf_path . $file_name;
} else {
    die('Tipo di documento non valido.');
}

// Verifica se il file esiste
if ($file_name && file_exists($file_path)) {
    // Forza il download del file
    header('Content-Disposition: attachment; filename="' . $file_name . '"');
    readfile($file_path);
} else {
    die('File non trovato.');
}
?>