<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

require_once 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['order_id'])) {
    $order_id = $_POST['order_id'];
    $user_id = $_SESSION['user_id'];

    // Verifica che l'ordine appartenga all'utente corrente
    $check_query = "SELECT * FROM rental_orders WHERE id = ? AND user = ?";
    $check_stmt = $conn->prepare($check_query);
    $check_stmt->bind_param('ii', $order_id, $user_id);
    $check_stmt->execute();
    $result = $check_stmt->get_result();

    if ($result->num_rows > 0) {
        // Verifica lo stato dell'ordine
        $order = $result->fetch_assoc();
        if ($order['status'] === 'IN_PROGRESS') {
            // Elimina l'ordine
            $delete_query = "DELETE FROM rental_orders WHERE id = ?";
            $delete_stmt = $conn->prepare($delete_query);
            $delete_stmt->bind_param('i', $order_id);
            if ($delete_stmt->execute()) {
                header('Location: dashboard.php?success=Ordine eliminato con successo.');
                exit;
            } else {
                header('Location: dashboard.php?error=Errore durante l\'eliminazione dell\'ordine.');
                exit;
            }
        } else {
            header('Location: dashboard.php?error=L\'ordine è già completato e non può essere eliminato.');
            exit;
        }
    } else {
        header('Location: dashboard.php?error=Ordine non trovato.');
        exit;
    }
} else {
    header('Location: dashboard.php?error=Richiesta non valida.');
    exit;
}
?>