<?php
session_start();

// Verifica login
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

require_once 'db.php';

// Recupera i noleggi
$user_id = $_SESSION['user_id'];
$query = "
    SELECT 
        MIN(id) AS first_id, 
        GROUP_CONCAT(device_code ORDER BY device_code SEPARATOR ', ') AS devices,
        rental_start, 
        MAX(rental_end) AS rental_end
    FROM rentals
    WHERE user_id = ?
    GROUP BY rental_start
    ORDER BY rental_start DESC
";
$stmt = $conn->prepare($query);
$stmt->bind_param('i', $user_id);
$stmt->execute();
$result = $stmt->get_result();
$groupedRentals = $result->fetch_all(MYSQLI_ASSOC);

$stmt->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Dashboard Utente</title>
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #2980b9;
            --bg-color: #ecf0f1;
            --white: #ffffff;
            --gray: #7f8c8d;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--bg-color);
            margin: 0;
        }

        .container {
            max-width: 960px;
            margin: 40px auto;
            background: var(--white);
            padding: 30px 40px;
            border-radius: 12px;
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }

        h1, h2 {
            text-align: center;
        }

        h1 {
            color: var(--primary-color);
            margin-bottom: 10px;
        }

        h2 {
            color: var(--secondary-color);
            margin-top: 40px;
            border-bottom: 2px solid var(--secondary-color);
            padding-bottom: 6px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 25px;
            font-size: 0.95rem;
        }

        th, td {
            padding: 12px 15px;
            border-bottom: 1px solid #ddd;
            text-align: left;
        }

        th {
            background-color: var(--primary-color);
            color: white;
        }

        tr:hover {
            background-color: #f9f9f9;
        }

        .logout {
            margin-top: 40px;
            text-align: center;
        }

        .logout a {
            color: var(--secondary-color);
            font-weight: bold;
            text-decoration: none;
        }

        .logout a:hover {
            text-decoration: underline;
        }

        .download-menu {
            position: relative;
            display: inline-block;
        }

        .download-button {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
        }

        .download-menu-content {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            background: var(--white);
            border: 1px solid #ccc;
            border-radius: 6px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            z-index: 100;
            min-width: 250px;
        }

        .download-menu-content a {
            display: block;
            padding: 10px 16px;
            color: var(--primary-color);
            text-decoration: none;
        }

        .download-menu-content a:hover {
            background-color: #f2f2f2;
        }

        .download-menu:hover .download-menu-content,
        .download-menu-content:hover {
            display: block;
        }

        @media (max-width: 600px) {
            table, thead, tbody, th, td, tr {
                display: block;
            }

            thead {
                display: none;
            }

            td {
                position: relative;
                padding-left: 50%;
                border: none;
                border-bottom: 1px solid #eee;
            }

            td::before {
                position: absolute;
                top: 12px;
                left: 16px;
                content: attr(data-label);
                font-weight: bold;
                color: var(--gray);
            }

            .download-menu-content {
                left: auto;
                right: 0;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <h1>Benvenuto, <?php echo htmlspecialchars($_SESSION['user_name']); ?>!</h1>

    <h2>Storico Noleggi</h2>

    <?php if (count($groupedRentals) > 0): ?>
        <table>
            <thead>
            <tr>
                <th>Dispositivi</th>
                <th>Data Inizio</th>
                <th>Data Fine</th>
                <th>Azioni</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($groupedRentals as $group): ?>
                <tr>
                    <td data-label="Dispositivi"><?php echo htmlspecialchars($group['devices']); ?></td>
                    <td data-label="Inizio"><?php echo htmlspecialchars($group['rental_start']); ?></td>
                    <td data-label="Fine"><?php echo htmlspecialchars($group['rental_end'] ?? 'In corso'); ?></td>
                    <td data-label="Azioni">
                        <div class="download-menu">
                            <button class="download-button" title="Scarica documenti">📄</button>
                            <div class="download-menu-content">
                                <a href="download.php?type=noleggio&id=<?php echo $group['first_id']; ?>" target="_blank">📥 Documento di Noleggio</a>
                                <a href="download.php?type=restituzione&id=<?php echo $group['first_id']; ?>" target="_blank">📥 Documento di Restituzione</a>
                            </div>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Non hai ancora effettuato alcun noleggio.</p>
    <?php endif; ?>

    <div class="logout">
        <a href="logout.php">Logout</a>
    </div>
</div>
</body>
</html>


                                    <!-- Pulsante per modificare l'ordine -->
                                   <button
                                        onclick="editOrder(<?php echo htmlspecialchars($order['id']); ?>)" 
                                        style="background-color: #3498db; height: 40px; color: white; border: none; padding: 8px 12px; border-radius: 4px; cursor: pointer;"
                                    >
                                        Modifica
                                    </button>