<?php
session_start();

// Verifica login
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

require_once 'db.php';

$user_id = $_SESSION['user_id'];

// Recupera codici già noleggiati per disponibilità
$stmt = $conn->prepare("SELECT device_code FROM rentals WHERE rental_end IS NULL");
$stmt->execute();
$result = $stmt->get_result();
$rented = [];
while ($row = $result->fetch_assoc()) {
    $rented[] = $row['device_code'];
}
$stmt->close();


// GESTIONE CREAZIONE ORDINE
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_order'])) {
    $tablet_qty = intval($_POST['tablet'] ?? 0);
    $laptop_qty = intval($_POST['laptop'] ?? 0);
    $visori_qty = intval($_POST['visori'] ?? 0);

    // Recupera codici già noleggiati
    $stmt = $conn->prepare("SELECT device_code FROM rentals WHERE rental_end IS NULL");
    $stmt->execute();
    $result = $stmt->get_result();
    $rented = [];
    while ($row = $result->fetch_assoc()) {
        $rented[] = $row['device_code'];
    }
    $stmt->close();

    function getAvailableDevices($conn, $prefix, $quantity, $rented) {
        $query = "SELECT d.codice 
                  FROM device d
                  WHERE d.codice LIKE ? 
                    AND d.stato IN ('FUNZIONANTE', 'PARZIALE') ";

        if (!empty($rented)) {
            $placeholders = implode(',', array_fill(0, count($rented), '?'));
            $query .= " AND d.codice NOT IN ($placeholders) ";
        }

        $query .= " ORDER BY d.codice ASC LIMIT ?";

        $params = array_merge(["$prefix%"], $rented, [$quantity]);
        $types = str_repeat('s', count($params) - 1) . 'i';

        $stmt = $conn->prepare($query);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();

        $available = [];
        while ($row = $result->fetch_assoc()) {
            $available[] = $row['codice'];
        }

        return $available;
    }

    $available_tablets = getAvailableDevices($conn, 'T_', $tablet_qty, $rented);
    $available_laptops = getAvailableDevices($conn, 'L_', $laptop_qty, $rented);
    $available_visori = getAvailableDevices($conn, 'V_', $visori_qty, $rented);

    $selected_devices = array_merge($available_tablets, $available_laptops, $available_visori);

    if (count($selected_devices) === ($tablet_qty + $laptop_qty + $visori_qty)) {
        $device_list = implode(',', $selected_devices);
        $stmt = $conn->prepare("INSERT INTO rental_orders (user, devices, status, created_at) VALUES (?, ?, 'IN_PROGRESS', NOW())");
        $stmt->bind_param("is", $user_id, $device_list);
        $stmt->execute();

        // Aggiorna lo stato dei dispositivi a PRENOTATO
        $placeholders = implode(',', array_fill(0, count($selected_devices), '?'));
        $update_query = "UPDATE device SET stato = 'PRENOTATO' WHERE codice IN ($placeholders)";
        $stmt_update = $conn->prepare($update_query);
        $stmt_update->bind_param(str_repeat('s', count($selected_devices)), ...$selected_devices);
        $stmt_update->execute();

        echo "<script>alert('Ordine creato con successo!');</script>";
    } else {
        echo "<script>alert('Dispositivi insufficienti disponibili per soddisfare la richiesta.');</script>";
    }
}

// GESTIONE ANNULLAMENTO ORDINI
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cancel_order'])) {
    $order_id = $_POST['cancel_order'];
    $conn->begin_transaction();

    try {
        $stmt_get_devices = $conn->prepare("SELECT devices FROM rental_orders WHERE id = ? AND user = ? AND status = 'IN_PROGRESS'");
        $stmt_get_devices->bind_param('ii', $order_id, $user_id);
        $stmt_get_devices->execute();
        $result_devices = $stmt_get_devices->get_result();
        $order = $result_devices->fetch_assoc();

        if ($order) {
            $devices = array_map('trim', explode(',', $order['devices']));
            $placeholders = implode(',', array_fill(0, count($devices), '?'));
            $update_query = "UPDATE device SET stato = 'FUNZIONANTE' WHERE codice IN ($placeholders)";
            $stmt_update = $conn->prepare($update_query);
            $stmt_update->bind_param(str_repeat('s', count($devices)), ...$devices);
            $stmt_update->execute();

            $stmt_delete = $conn->prepare("DELETE FROM rental_orders WHERE id = ?");
            $stmt_delete->bind_param('i', $order_id);
            $stmt_delete->execute();

            $conn->commit();
            echo "<script>alert('Prenotazione annullata con successo!');</script>";
        } else {
            echo "<script>alert('Errore: Prenotazione non trovata o già completata.');</script>";
        }
    } catch (Exception $e) {
        $conn->rollback();
        echo "<script>alert('Errore durante l\\'annullamento della prenotazione: " . $e->getMessage() . "');</script>";
    }
}

// RECUPERA ORDINI ATTIVI
$stmt_orders = $conn->prepare("SELECT id, devices, status, created_at FROM rental_orders WHERE user = ? ORDER BY created_at DESC");
$stmt_orders->bind_param('i', $user_id);
$stmt_orders->execute();
$result_orders = $stmt_orders->get_result();
$userOrders = $result_orders->fetch_all(MYSQLI_ASSOC);

// RECUPERA STORICO NOLEGGI
$stmt_history = $conn->prepare("
    SELECT MIN(id) AS first_id, GROUP_CONCAT(device_code ORDER BY device_code SEPARATOR ', ') AS devices, rental_start, MAX(rental_end) AS rental_end 
    FROM rentals 
    WHERE user_id = ? 
    GROUP BY rental_start 
    ORDER BY rental_start DESC
");
$stmt_history->bind_param('i', $user_id);
$stmt_history->execute();
$result_history = $stmt_history->get_result();
$groupedRentals = $result_history->fetch_all(MYSQLI_ASSOC);

// CALCOLA DISPONIBILITÀ DEI DISPOSITIVI
function countAvailableDevices($conn, $prefix, $rented) {
    $query = "SELECT COUNT(*) AS count 
              FROM device 
              WHERE codice LIKE ? 
                AND stato IN ('FUNZIONANTE', 'PARZIALE')";

    if (!empty($rented)) {
        $placeholders = implode(',', array_fill(0, count($rented), '?'));
        $query .= " AND codice NOT IN ($placeholders)";
    }

    $params = array_merge(["$prefix%"], $rented);
    $types = str_repeat('s', count($params));

    $stmt = $conn->prepare($query);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'];
}

$tablet_available = countAvailableDevices($conn, 'T_', $rented);
$laptop_available = countAvailableDevices($conn, 'L_', $rented);
$visori_available = countAvailableDevices($conn, 'V_', $rented);

$conn->close();
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Dashboard Utente</title>
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #2980b9;
            --bg-color: #ecf0f1;
            --white: #ffffff;
            --gray: #7f8c8d;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--bg-color);
            margin: 0;
        }

        .container {
            max-width: 960px;
            margin: 40px auto;
            background: var(--white);
            padding: 30px 40px;
            border-radius: 12px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }

        .navbar {
            display: flex;
            justify-content: space-around;
            margin-bottom: 20px;
        }

        .navbar button {
            background: none;
            border: none;
            color: var(--secondary-color);
            font-size: 1rem;
            cursor: pointer;
        }

        .section {
            display: none;
        }

        .section.active {
            display: block;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 25px;
            font-size: 0.95rem;
        }

        th, td {
            padding: 12px 15px;
            border-bottom: 1px solid #ddd;
            text-align: left;
        }

        th {
            background-color: var(--primary-color);
            color: white;
        }

        tr:hover {
            background-color: #f9f9f9;
        }

        .actions {
            display: flex;
            gap: 10px;
        }

        .actions button {
            background: none;
            border: none;
            color: var(--secondary-color);
            font-size: 1rem;
            cursor: pointer;
        }
        .download-menu {
    position: relative;
    display: inline-block;
}

.download-button {
    background: none;
    border: none;
    font-size: 1.2rem;
    cursor: pointer;
}

.download-menu-content {
    display: none;
    position: absolute;
    background-color: var(--white);
    min-width: 180px;
    box-shadow: 0px 8px 16px rgba(0,0,0,0.2);
    z-index: 1;
    padding: 8px 0;
    border-radius: 8px;
}

.download-menu-content a {
    color: var(--primary-color);
    padding: 10px 16px;
    text-decoration: none;
    display: block;
}

.download-menu-content a:hover {
    background-color: #f1f1f1;
}

.download-menu:hover .download-menu-content {
    display: block;
}
  .device-selection {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 20px;
    margin-top: 20px;
  }

  .device-card {
    background: var(--white);
    padding: 16px;
    border-radius: 8px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    text-align: center;
  }

  .device-card label {
    font-weight: bold;
    display: block;
    margin-bottom: 8px;
  }

  .device-card input {
    width: 60px;
    padding: 6px;
    font-size: 1rem;
  }

  .device-available {
    display: block;
    margin-top: 4px;
    color: var(--gray);
    font-size: 0.9rem;
  }

  .order-actions {
    margin-top: 20px;
    text-align: center;
  }

  .order-actions button {
    background: var(--secondary-color);
    color: var(--white);
    border: none;
    padding: 12px 24px;
    font-size: 1rem;
    cursor: pointer;
    border-radius: 6px;
  }

  .order-actions button:disabled {
    background: #bdc3c7;
    cursor: not-allowed;
  }
  /* Stili generali per la sezione Account */
#account {
    margin-top: 20px;
}

#account h2 {
    text-align: center;
    color: var(--secondary-color);
    margin-bottom: 20px;
    border-bottom: 2px solid var(--secondary-color);
    padding-bottom: 10px;
}

/* Form di modifica password */
#account form {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 15px;
    max-width: 400px;
    margin: 0 auto;
}

/* Label per i campi */
#account label {
    font-size: 1rem;
    font-weight: bold;
    color: var(--primary-color);
    text-align: left;
    width: 100%;
}

/* Input per i campi password */
#account input[type="password"] {
    width: 100%;
    padding: 10px;
    font-size: 1rem;
    border: 1px solid #ccc;
    border-radius: 4px;
    transition: border-color 0.3s ease;
}

#account input[type="password"]:focus {
    border-color: var(--secondary-color);
    outline: none;
}

/* Pulsante di invio */
#account button[type="submit"] {
    background-color: var(--secondary-color);
    color: white;
    border: none;
    padding: 10px 20px;
    font-size: 1rem;
    border-radius: 4px;
    cursor: pointer;
    transition: background-color 0.3s ease;
}

#account button[type="submit"]:hover {
    background-color: var(--primary-color);
}

/* Responsive Design */
@media (max-width: 600px) {
    #account form {
        gap: 10px;
    }

    #account label {
        font-size: 0.9rem;
    }

    #account input[type="password"] {
        padding: 8px;
        font-size: 0.9rem;
    }

    #account button[type="submit"] {
        padding: 8px 16px;
        font-size: 0.9rem;
    }
}
    </style>
</head>
<body>
<div class="container">
    <h1>Benvenuto, <?php echo htmlspecialchars($_SESSION['user_name']); ?>!</h1>

    <!-- Navbar -->
    <div class="navbar">
        <button onclick="showSection('dashboard')">Dashboard</button>
        <button onclick="showSection('account')">Account</button>
        <button onclick="showSection('orders')">Ordini</button>
    </div>

    <!-- Dashboard Section -->
    <div id="dashboard" class="section active">
        <h2>Storico Noleggi</h2>
        <?php if (count($groupedRentals) > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>Dispositivi</th>
                        <th>Data Inizio</th>
                        <th>Data Fine</th>
                        <th>Azioni</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($groupedRentals) > 0): ?>
                        <?php foreach ($groupedRentals as $group): ?>
                            <tr>
                                <td data-label="Dispositivi"><?php echo htmlspecialchars($group['devices']); ?></td>
                                <td data-label="Data Inizio"><?php echo htmlspecialchars($group['rental_start']); ?></td>
                                <td data-label="Data Fine"><?php echo htmlspecialchars($group['rental_end'] ?? 'In corso'); ?></td>
                                <td data-label="Azioni">
                                    <div class="download-menu">
                                        <button class="download-button" title="Scarica documenti">📄</button>
                                        <div class="download-menu-content">
                                            <a href="download.php?type=noleggio&id=<?php echo $group['first_id']; ?>" target="_blank">📥 Documento di Noleggio</a>
                                            <a href="download.php?type=restituzione&id=<?php echo $group['first_id']; ?>" target="_blank">📥 Documento di Restituzione</a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4">Non hai ancora effettuato alcun noleggio.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Non hai ancora effettuato alcun noleggio.</p>
        <?php endif; ?>
    </div>

    <!-- Account Section -->
    <div id="account" class="section">
        <h2>Modifica Password</h2>
        <form action="update_password.php" method="POST">
            <label for="current_password">Password Attuale:</label>
            <input type="password" id="current_password" name="current_password" required />
            <br />
            <label for="new_password">Nuova Password:</label>
            <input type="password" id="new_password" name="new_password" required />
            <br />
            <button type="submit">Aggiorna Password</button>
        </form>
    </div>

    <!-- Orders Section -->
    <div id="orders" class="section">
        <h2>I Tuoi Ordini</h2>
        <?php if (count($userOrders) > 0): ?>
            <table>
                <thead>
                <tr>
                    <th>ID Ordine</th>
                    <th>Dispositivi</th>
                    <th>Data Creazione</th>
                    <th>Stato</th>
                    <th>Azioni</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($userOrders as $order): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($order['id']); ?></td>
                        <td><?php echo htmlspecialchars($order['devices']); ?></td>
                        <td><?php echo htmlspecialchars($order['created_at']); ?></td>
                        <td><?php echo htmlspecialchars($order['status']); ?></td>
                        <td>
                            <div class="actions" style="display: flex; justify-content: center; gap: 10px;">
                                <?php if ($order['status'] === 'IN_PROGRESS'): ?>
                                    <!-- Form per annullare l'ordine -->
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="cancel_order" value="<?php echo htmlspecialchars($order['id']); ?>" />
                                        <button 
                                            type="submit" 
                                            onclick="return confirm('Sei sicuro di voler annullare questa prenotazione?');" 
                                            style="background-color: #e74c3c;margin-top: 9px; height: 40px; color: white; border: none; padding: 8px 12px; border-radius: 4px; cursor: pointer;"
                                        >
                                            Annulla
                                        </button>
                                    </form>

                                    <!-- Pulsante per modificare l'ordine -->
                                   <button
                                        onclick="editOrder(<?php echo htmlspecialchars($order['id']); ?>)" 
                                        style="background-color: #3498db; margin-top: 9px; height: 40px; color: white; border: none; padding: 8px 12px; border-radius: 4px; cursor: pointer;"
                                    >
                                        Modifica
                                    </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Non hai ancora effettuato alcun ordine.</p>
        <?php endif; ?>

        <h2>Nuovo Ordine</h2>
<form method="POST" id="createOrderForm">
  <div class="device-selection">
    <div class="device-card">
      <label for="tablet">Tablet</label>
      <input type="number" id="tablet" name="tablet" min="0" max="<?php echo $tablet_available; ?>" value="0" />
      <span class="device-available">(Disponibili: <?php echo $tablet_available; ?>)</span>
    </div>
    <div class="device-card">
      <label for="laptop">Laptop</label>
      <input type="number" id="laptop" name="laptop" min="0" max="<?php echo $laptop_available; ?>" value="0" />
      <span class="device-available">(Disponibili: <?php echo $laptop_available; ?>)</span>
    </div>
    <div class="device-card">
      <label for="visori">Visori</label>
      <input type="number" id="visori" name="visori" min="0" max="<?php echo $visori_available; ?>" value="0" />
      <span class="device-available">(Disponibili: <?php echo $visori_available; ?>)</span>
    </div>
  </div>

  <input type="hidden" name="create_order" value="1" />
  <div class="order-actions">
    <button type="submit" id="submitOrder">Crea Ordine</button>
  </div>
</form>

    </div>
</div>

<script>
  const form = document.getElementById('createOrderForm');
  const inputs = form.querySelectorAll('input[type="number"]');
  const submitBtn = document.getElementById('submitOrder');

  function updateButtonState() {
    let total = 0;
    inputs.forEach(i => { total += parseInt(i.value, 10) || 0; });
    submitBtn.disabled = total === 0;
  }

  inputs.forEach(i => {
    i.addEventListener('input', () => {
      // Impedisce valore negativo o superiore a max
      const max = parseInt(i.max);
      if (i.value < 0) i.value = 0;
      if (i.value > max) i.value = max;
      updateButtonState();
    });
  });

  updateButtonState();

    function showSection(sectionId) {
        document.querySelectorAll('.section').forEach(section => section.classList.remove('active'));
        document.getElementById(sectionId).classList.add('active');
    }

    function editOrder(orderId) {
        alert(`Modifica l'ordine con ID ${orderId}`);
        // Qui puoi implementare la logica per modificare l'ordine
    }
</script>
</body>
</html>