<?php
include 'db.php';
require 'fpdf/fpdf.php';
require 'phpqrcode/qrlib.php';
session_start();

// Funzione PDF personalizzata
class PDF extends FPDF {
    function Header() {
        if (file_exists('fermi.png')) {
            $this->Image('fermi.png', 10, 10, 190);
            $this->Ln(30);
        }
        $this->SetFont('Arial','B',12);
        $this->Ln(15);
    }
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Pagina '.$this->PageNo().'/{nb}',0,0,'C');
        $this->SetY(-10);
        $this->SetFont('Arial','I',5);
        $this->Cell(0,10,'Realizzato da RICCHIUTO Michele 4CI. Tutti i diritti riservati',0,0,'C');
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['crea_utente'])) {
    $name = trim($_POST['nome']);
    $email = trim($_POST['email']);
    $firma_data = $_POST['firma'] ?? '';

    if ($name !== '' && filter_var($email, FILTER_VALIDATE_EMAIL) && $firma_data !== '') {
        // Cartelle
        if (!is_dir('firme_utente')) mkdir('firme_utente', 0777, true);
        if (!is_dir('qrcode')) mkdir('qrcode', 0777, true);
        if (!is_dir('tessere_utente')) mkdir('tessere_utente', 0777, true);

        // Salva firma
        $firma_data = str_replace('data:image/png;base64,', '', $firma_data);
        $firma_bin = base64_decode($firma_data);
        $firma_path = 'firme_utente/' . $email . '.png';
        file_put_contents($firma_path, $firma_bin);

        // Crea QR
        $qr_path = 'qrcode/qrcode_' . md5($email) . '.png';
        QRcode::png($email, $qr_path, QR_ECLEVEL_H, 5);

        // Salva o aggiorna nel DB
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $stmt->close();
            $update = $conn->prepare("UPDATE users SET name = ? WHERE email = ?");
            $update->bind_param("ss", $name, $email);
            $update->execute();
            $update->close();
        } else {
            $stmt->close();
            $insert = $conn->prepare("INSERT INTO users (name, email) VALUES (?, ?)");
            $insert->bind_param("ss", $name, $email);
            $insert->execute();
            $insert->close();
        }

        // CREA PDF
        $pdf = new PDF();
        $pdf->AliasNbPages();
        $pdf->AddPage();
        $pdf->SetFont('Arial','',12);

        // Dati anagrafici
        $pdf->SetXY(10, 50);
        $pdf->Cell(0, 10, "Nome: $name", 0, 1);
        $pdf->SetX(10);
        $pdf->Cell(0, 10, "Email: $email", 0, 1);

        // QR a destra sotto logo
        if (file_exists($qr_path)) {
            $pdf->Image($qr_path, 150, 50, 40);
        }

        // Spazio prima delle firme
        $pdf->Ln(60);

        // Titoli
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(90, 10, "Firma Cliente", 0, 0, 'L');
        $pdf->SetX(150);
        $pdf->Cell(40, 10, "Timbro Ufficio", 0, 1, 'L');

        // Immagini sotto titoli
        $y = $pdf->GetY() + 3;
        if (file_exists($firma_path)) {
            $pdf->Image($firma_path, 10, $y, 60);
        }
        if (file_exists('firma_uff.png')) {
            $pdf->Image('firma_uff.png', 150, $y, 40);
        }

        // Salva PDF
        $pdf_path = 'tessere_utente/tessera_' . md5($email) . '.pdf';
        $pdf->Output('F', $pdf_path);

        $_SESSION['message'] = "Tessera generata con successo.";
        header("Location: crea_tessera.php");
        exit;
    } else {
        $_SESSION['message'] = "Dati non validi.";
        header("Location: crea_tessera.php");
        exit;
    }
}
?>

<!-- HTML -->
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Genera Tessera Utente</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        canvas { border:1px solid #ccc; background:white; border-radius:8px; }
        .container { max-width: 800px; margin-top: 40px; }
    </style>
</head>
<body>
<div class="container">
    <h2>Genera Tessera Utente (con Firma, Timbro e QR)</h2>
    <?php if (isset($_SESSION['message'])) { echo '<div class="alert alert-info">' . $_SESSION['message'] . '</div>'; unset($_SESSION['message']); } ?>
    <form method="post" onsubmit="return firmaSubmit()">
        <input type="hidden" name="crea_utente" value="1" />
        <div class="mb-3">
            <label>Nome</label>
            <input type="text" name="nome" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Firma Utente</label><br>
            <canvas id="firma" width="600" height="200"></canvas>
            <input type="hidden" name="firma" id="firma_val">
            <br><button type="button" class="btn btn-secondary mt-2" onclick="firmaClear()">Pulisci Firma</button>
        </div>
        <button type="submit" class="btn btn-primary">Genera Tessera</button>
    </form>

    <hr>
    <h4>Tessere Generate</h4>
    <ul>
        <?php
        foreach (glob("tessere_utente/*.pdf") as $file) {
            $base = basename($file);
            echo "<li><a href='$file' target='_blank'>$base</a></li>";
        }
        ?>
    </ul>
</div>
<script>
const canvas = document.getElementById('firma');
const ctx = canvas.getContext('2d');
let drawing = false, lastPos = {x:0,y:0};
canvas.addEventListener('mousedown', e => { drawing = true; lastPos = getMouse(e); });
canvas.addEventListener('mouseup', () => drawing = false);
canvas.addEventListener('mousemove', e => {
    if (!drawing) return;
    const pos = getMouse(e);
    ctx.beginPath(); ctx.moveTo(lastPos.x,lastPos.y); ctx.lineTo(pos.x,pos.y);
    ctx.strokeStyle = 'black'; ctx.lineWidth = 2; ctx.stroke(); ctx.closePath();
    lastPos = pos;
});
function getMouse(e){ const r = canvas.getBoundingClientRect(); return {x: e.clientX - r.left, y: e.clientY - r.top}; }
function firmaClear(){ ctx.clearRect(0,0,canvas.width,canvas.height); }
function firmaSubmit(){ document.getElementById('firma_val').value = canvas.toDataURL('image/png'); return true; }
</script>
</body>
</html>
