<?php
include 'db.php';

$uid = isset($_GET['uid']) ? trim($_GET['uid']) : '';

header('Content-Type: application/json');

if (empty($uid)) {
    echo json_encode(['success' => false, 'message' => 'UID mancante']);
    exit;
}

$stmt = $conn->prepare("SELECT device_name FROM uidisp WHERE uid = ?");
$stmt->bind_param("s", $uid);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo json_encode(['success' => true, 'device' => $row['device_name']]);
} else {
    echo json_encode(['success' => false, 'message' => 'UID non trovato']);
}

$stmt->close();
?>
