<?php
include 'db.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $device_name = trim($_POST['device_name'] ?? '');
    if (!empty($device_name)) {
        // Controlla se il dispositivo esiste già nel database
        $stmt = $conn->prepare("SELECT codice FROM device WHERE device_name = ?");
        $stmt->bind_param("s", $device_name);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $device_code = $row['codice'];

            // Aggiungi il dispositivo alla sessione corrente
            if (!isset($_SESSION['noleggio_devices'])) {
                $_SESSION['noleggio_devices'] = [];
            }
            $_SESSION['noleggio_devices'][] = $device_code;

            echo json_encode(['success' => true, 'message' => 'Dispositivo aggiunto al noleggio']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Dispositivo non trovato']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Nome dispositivo mancante']);
    }
}
?>