<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestionale Software Visori</title>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap');
        body {
            background-color: #f4f6f9;
            font-family: 'Inter', 'Segoe UI', sans-serif;
            margin: 0;
            padding: 0;
            color: #333;
        }
        /* Navbar */
        .navbar {
            background: #4e54c8;
            color: white;
            display: flex;
            height: 25px;
            align-items: center;
            justify-content: space-between;
            padding: 16px 40px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            position: relative;
            font-size: 1rem;
        }
        .navbar-brand {
            font-size: 1.4rem;
            font-weight: 600;
        }
        .nav-link {
            background: none;
            border: none;
            color: white;
            font-weight: 500;
            margin-left: 20px;
            cursor: pointer;
            font-size: 0.95rem;
        }
        .nav-link:hover {
            text-decoration: bold;
            text-decoration: underline;
            color: rgb(182, 182, 182);
        }
        /* Container */
        .container {
            max-width: 1000px;
            margin: 40px auto;
            padding: 0 20px;
        }
        /* Card */
        .card {
            background: white;
            border-radius: 16px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.07);
            padding: 30px;
        }
        /* Tabella */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 25px;
            border-radius: 10px;
            overflow: hidden;
        }
        th {
            background-color: #4e54c8;
            color: white;
            padding: 14px;
            text-align: left;
            font-weight: 600;
        }
        td {
            padding: 14px;
            border-bottom: 1px solid #eee;
            background-color: #fff;
        }
        tr:hover td {
            background-color: #f1f3ff;
        }
        /* Pulsanti */
        .btn-primary {
            background-color: #4e54c8;
            color: white;
            border: none;
            border-radius: 8px;
            padding: 10px 18px;
            font-size: 0.95rem;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.2s ease-in-out;
        }
        .btn-primary:hover {
            background-color: #3c40b0;
        }
        /* Modali */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.4);
        }
        .modal-content {
            background: white;
            margin: 8% auto;
            padding: 25px 30px;
            border-radius: 14px;
            width: 90%;
            max-width: 600px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        }
        .modal-content h2 {
            margin-top: 0;
        }
        .close {
            float: right;
            font-size: 26px;
            color: #999;
            cursor: pointer;
        }
        .close:hover {
            color: #333;
        }
        /* Input & Select */
        input[type="text"], select {
            width: 100%;
            padding: 10px;
            margin: 10px 0 20px;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 1rem;
            transition: border 0.2s ease;
        }
        input[type="text"]:focus, select:focus {
            border-color: #4e54c8;
            outline: none;
        }
        /* Footer */
        footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: white;
            color: #888;
            font-size: 0.85rem;
            text-align: center;
            padding: 12px 0;
            border-top: 1px solid #ddd;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="container">
            <div>
                <button class="nav-link" onclick="openSearchModal()">Cerca Software</button>
                <button class="nav-link" onclick="openAddSoftwareModal()">Aggiungi Software</button>
                <button class="nav-link" onclick="openAssignSoftwareModal()">Assegna Software</button>
                <button class="nav-link" style="margin-left: 50px; color:rgb(255, 255, 255);" onclick="window.location.href='http://ricchiuto.iliadboxos.it:50000/NOLEGGI'">NOLEGGI</button>
            </div>
        </div>
    </nav>

    <!-- Contenuto principale -->
    <div class="container">
        <div class="card">
            <h2>Elenco Visori</h2>
            <table id="visori-table">
                <thead>
                    <tr>
                        <th>Visore ID</th>
                        <th>Software Installati</th>
                        <th>Azioni</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Connessione al database
                    $conn = new mysqli("localhost", "root", "", "noleggi");
                    if ($conn->connect_error) {
                        die("Connessione fallita: " . $conn->connect_error);
                    }

                    // Query per ottenere i visori e tutti i loro software installati
                    $sql = "
                        SELECT v.visore_id, GROUP_CONCAT(s.nome SEPARATOR ', ') as software_nomi
                        FROM (
                            SELECT 'V2595' AS visore_id UNION ALL
                            SELECT 'V2596' UNION ALL
                            SELECT 'V2597' UNION ALL
                            SELECT 'V2598' UNION ALL
                            SELECT 'V2599' UNION ALL
                            SELECT 'V2600' UNION ALL
                            SELECT 'V2601' UNION ALL
                            SELECT 'V2602' UNION ALL
                            SELECT 'V2603' UNION ALL
                            SELECT 'V2604' UNION ALL
                            SELECT 'V2605' UNION ALL
                            SELECT 'V2606' UNION ALL
                            SELECT 'V2607' UNION ALL
                            SELECT 'V2608' UNION ALL
                            SELECT 'V2609' UNION ALL
                            SELECT 'V2610' UNION ALL
                            SELECT 'V2611' UNION ALL
                            SELECT 'V2612' UNION ALL
                            SELECT 'V2613' UNION ALL
                            SELECT 'V2614'
                        ) v
                        LEFT JOIN elencosoftwarevr es ON v.visore_id = es.visore_id
                        LEFT JOIN softwarevr s ON es.software_id = s.id
                        GROUP BY v.visore_id;
                    ";
                    $result = $conn->query($sql);

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            echo "<tr>";
                            echo "<td>" . htmlspecialchars($row["visore_id"]) . "</td>";
                            echo "<td>" . (empty($row["software_nomi"]) ? "Nessun software installato" : htmlspecialchars($row["software_nomi"])) . "</td>";
                            echo "<td><button class='btn-primary' onclick='openAssignSoftwareModal()'>Assegna Software</button></td>";
                            echo "</tr>";
                        }
                    } else {
                        echo "<tr><td colspan='3'>Nessun visore trovato.</td></tr>";
                    }

                    $conn->close();
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modale per cercare software -->
    <div id="search-software-modal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2>Cerca Software</h2>
            <form id="search-software-form">
                <label for="school-address">Indirizzo Scolastico:</label>
                <select id="school-address" required>
                    <option value="">Seleziona un indirizzo</option>
                    <option value="informatica">Informatica</option>
                    <option value="elettrotecnica">Elettrotecnica</option>
                    <option value="trasporti-logistica">Trasporti e Logistica</option>
                    <option value="meccanica">Meccanica</option>
                    <option value="scientifico">Scientifico</option>
                </select>
                <button type="submit" class="btn-primary">Cerca</button>
            </form>
            <table id="search-results-table" style="margin-top: 20px; display: none;">
                <thead>
                    <tr>
                        <th>Visore ID</th>
                        <th>Software Installati</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>

    <!-- Modale per aggiungere nuovo software -->
    <div id="add-software-modal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2>Aggiungi Nuovo Software</h2>
            <form id="add-new-software-form">
                <label for="new-software-name">Nome Software:</label>
                <input type="text" id="new-software-name" required>
                <label for="new-software-address">Indirizzo Scolastico:</label>
                <select id="new-software-address" required>
                    <option value="informatica">Informatica</option>
                    <option value="elettrotecnica">Elettrotecnica</option>
                    <option value="trasporti-logistica">Trasporti e Logistica</option>
                    <option value="meccanica">Meccanica</option>
                    <option value="scientifico">Scientifico</option>
                    <option value="universale">UNIVERSALE</option>
                </select>
                <button type="submit" class="btn-primary">Aggiungi</button>
            </form>
        </div>
    </div>

    <!-- Modale per assegnare software -->
    <div id="assign-software-modal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2>Assegna Software ai Visori</h2>
            <form id="assign-software-form">
                <label for="software-select">Seleziona Software:</label>
                <select id="software-select" required>
                    <?php
                    // Query per ottenere tutti i software disponibili
                    $conn = new mysqli("localhost", "root", "", "noleggi");
                    if ($conn->connect_error) {
                        die("Connessione fallita: " . $conn->connect_error);
                    }

                    $sql = "SELECT id, nome FROM softwarevr";
                    $result = $conn->query($sql);

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            echo "<option value='" . htmlspecialchars($row["id"]) . "'>" . htmlspecialchars($row["nome"]) . "</option>";
                        }
                    }

                    $conn->close();
                    ?>
                </select>
                <label for="visor-select">Seleziona Visori:</label>
                <select id="visor-select" multiple required>
                    <?php
                    // Elenco predefinito dei visori
                    for ($i = 2595; $i <= 2614; $i++) {
                        echo "<option value='V" . $i . "'>V" . $i . "</option>";
                    }
                    ?>
                </select>
                <button type="submit" class="btn-primary">Assegna</button>
            </form>
        </div>
    </div>

    <!-- Footer -->
    <footer>
        &copy; 2025 Ricchiuto Michele 4CI. Tutti i diritti riservati.
    </footer>

    <!-- Script JavaScript -->
    <script>
        function openSearchModal() {
            document.getElementById('search-software-modal').style.display = 'block';
        }
        function openAddSoftwareModal() {
            document.getElementById('add-software-modal').style.display = 'block';
        }
        function openAssignSoftwareModal() {
            document.getElementById('assign-software-modal').style.display = 'block';
        }
        function closeModal() {
            document.getElementById('search-software-modal').style.display = 'none';
            document.getElementById('add-software-modal').style.display = 'none';
            document.getElementById('assign-software-modal').style.display = 'none';
        }
        document.getElementById('search-software-form').addEventListener('submit', function(event) {
            event.preventDefault();
            const address = document.getElementById('school-address').value;
            fetch('search_software.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ address: address })
            })
            .then(response => response.json())
            .then(data => {
                const tableBody = document.querySelector('#search-results-table tbody');
                tableBody.innerHTML = '';
                if (data.length > 0) {
                    data.forEach(row => {
                        const tr = document.createElement('tr');
                        tr.innerHTML = `
                            <td>${row.visore_id}</td>
                            <td>${row.software_nomi || 'Nessun software installato'}</td>
                        `;
                        tableBody.appendChild(tr);
                    });
                    document.getElementById('search-results-table').style.display = 'table';
                } else {
                    alert('Nessun risultato trovato.');
                }
            })
            .catch(error => {
                console.error('Errore:', error);
                alert('Errore durante la comunicazione con il server.');
            });
        });
        document.getElementById('add-new-software-form').addEventListener('submit', function(event) {
            event.preventDefault();
            const softwareName = document.getElementById('new-software-name').value;
            const softwareAddress = document.getElementById('new-software-address').value;
            fetch('add_software.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    name: softwareName,
                    address: softwareAddress
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Nuovo software aggiunto con successo!');
                    closeModal();
                    location.reload(); // Aggiorna la pagina
                } else {
                    alert('Errore: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Errore:', error);
                alert('Errore durante la comunicazione con il server.');
            });
        });
        document.getElementById('assign-software-form').addEventListener('submit', function(event) {
            event.preventDefault();
            const softwareId = document.getElementById('software-select').value;
            const visorIds = Array.from(document.getElementById('visor-select').selectedOptions).map(option => option.value);
            fetch('assign_software.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    softwareId: softwareId,
                    visorIds: visorIds
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Software assegnato con successo!');
                    closeModal();
                    location.reload(); // Aggiorna la pagina
                } else {
                    alert('Errore: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Errore:', error);
                alert('Errore durante la comunicazione con il server.');
            });
        });
        // Gestione della modale
        window.onclick = function(event) {
            if (event.target == document.getElementById('search-software-modal')) {
                closeModal();
            }
            if (event.target == document.getElementById('add-software-modal')) {
                closeModal();
            }
            if (event.target == document.getElementById('assign-software-modal')) {
                closeModal();
            }
        };
    </script>
</body>
</html>