<?php
// Abilita il debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Connessione al database
$conn = new mysqli("localhost", "root", "", "noleggi");
if ($conn->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Connessione fallita: ' . $conn->connect_error]));
}

// Ricevi i dati dal client
$data = json_decode(file_get_contents('php://input'), true);
if (!$data) {
    die(json_encode(['success' => false, 'message' => 'Dati non ricevuti']));
}

$name = $data['name'];
$address = $data['address'];

// Inserisci il nuovo software nel database
$sql = "INSERT INTO softwarevr (nome, indirizzo_scolastico) VALUES (?, ?)";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    die(json_encode(['success' => false, 'message' => 'Errore nella preparazione della query: ' . $conn->error]));
}
$stmt->bind_param("ss", $name, $address);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Nuovo software aggiunto con successo']);
} else {
    echo json_encode(['success' => false, 'message' => 'Errore durante l\'inserimento: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>