<?php
include 'db.php';

// Gestione del nuovo noleggio da zero
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_rental_from_zero'])) {
    // Recupera i dati del form
    $user_id = $_POST['user_id'];
    $new_user_name = $_POST['new_user_name'] ?? null;
    $new_user_email = $_POST['new_user_email'] ?? null;
    $device_codes = $_POST['device_codes'] ?? [];
    $start = date('Y-m-d H:i:s');

    // Se è stato inserito un nuovo utente, aggiungilo al database
    if (!empty($new_user_name) && !empty($new_user_email)) {
        $stmt = $conn->prepare("INSERT INTO users (name, email) VALUES (?, ?)");
        if (!$stmt) die("Errore insert utente: " . $conn->error);
        $stmt->bind_param("ss", $new_user_name, $new_user_email);
        $stmt->execute();
        $user_id = $stmt->insert_id;
        $stmt->close();
    }

    // Inserisci i noleggi nel database
    foreach ($device_codes as $code) {
        $stmt = $conn->prepare("INSERT INTO rentals (device_code, user_id, rental_start) VALUES (?, ?, ?)");
        if (!$stmt) die("Errore insert noleggio: " . $conn->error);
        $stmt->bind_param("sis", $code, $user_id, $start);
        $stmt->execute();
        $stmt->close();
    }

    // Salva la firma digitale come immagine
    if (isset($_POST['signature'])) {
        $signature_data = $_POST['signature'];
        $signature_image = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $signature_data));
        $signature_path = "signatures/signature_" . uniqid() . ".png";
        file_put_contents($signature_path, $signature_image);
    } else {
        die("Firma digitale non fornita.");
    }

    // Genera il PDF
    require('fpdf/fpdf.php');
    $pdf = new FPDF();
    $pdf->AddPage();
    $pdf->SetFont('Arial', 'B', 16);

    // Contenuto del PDF
    $pdf->Cell(40, 10, 'Riepilogo Noleggio');
    $pdf->Ln();
    $pdf->Cell(40, 10, 'Utente: ' . ($new_user_name ?? 'Esistente'));
    $pdf->Ln();
    $pdf->Cell(40, 10, 'Dispositivi: ' . implode(', ', $device_codes));
    $pdf->Ln();
    $pdf->Cell(40, 10, 'Firma: ');
    $pdf->Image($signature_path, 50, 50, 50);

    // Salva il PDF
    $pdf_path = "pdfs/rental_summary_" . uniqid() . ".pdf";
    $pdf->Output('F', $pdf_path);

    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Nuovo Noleggio da Zero</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap @5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons @1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <!-- jQuery Signature -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/jq-signature/1.0.0/jq-signature.min.css " rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js "></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jq-signature/1.0.0/jq-signature.min.js "></script>
    <style>
        body { background: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
        .navbar { background: linear-gradient(90deg, #4e54c8, #8f94fb); }
        .navbar-brand, .nav-link { color: white !important; }
        .nav-link:hover { text-decoration: underline; color: #d1d1f9 !important; }
        .container { margin-top: 30px; }
        .card { border: none; border-radius: 20px; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1); }
        table { border-radius: 10px; overflow: hidden; }
        .btn-primary { background-color: #4e54c8; border: none; }
        .btn-primary:hover { background-color: #3b3fc0; }
        footer { position: fixed; bottom: 0; width: 100%; background: white; color: #ccc; font-size: 0.9rem; text-align: center; padding: 0.75rem 0; z-index: 1030; }
    </style>
    <script>
        $(document).ready(function () {
            // Inizializza la firma digitale
            $('#signature-pad').jqSignature();

            // Bottone per cancellare la firma
            $('#clear-signature').on('click', function () {
                $('#signature-pad').jqSignature('clearCanvas');
            });

            // Invia la firma digitale con il form
            $('#new_rental_form').on('submit', function (e) {
                if ($('#signature-pad').jqSignature('isEmpty')) {
                    alert("Per favore, firma prima di confermare.");
                    e.preventDefault(); // Impedisce l'invio del form
                } else {
                    const signatureData = $('#signature-pad').jqSignature('getDataURL'); // Ottieni la firma in formato base64
                    $('#signature-data').val(signatureData); // Salva nel campo nascosto
                }
            });
        });
    </script>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
        <a class="navbar-brand" href="#">Gestione Noleggi</a>
        <div class="collapse navbar-collapse">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item"><a class="nav-link" href="index.php">Torna alla Home</a></li>
            </ul>
        </div>
    </div>
</nav>
<div class="container">
    <div class="card p-4">
        <h3>Nuovo Noleggio da Zero</h3>
        <form method="post" class="row g-3" id="new_rental_form">
            <!-- Sezione: Dati Utente -->
            <div class="col-md-6">
                <label class="form-label">Utente</label>
                <select name="user_id" class="form-select" id="user_select">
                    <option value="">Seleziona utente esistente</option>
                    <?php
                    $users = $conn->query("SELECT id, name, email FROM users ORDER BY name");
                    while ($u = $users->fetch_assoc()) {
                        echo "<option value='{$u['id']}'>{$u['name']} ({$u['email']})</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-6" id="new_user_section" style="display:none;">
                <h5>Inserisci Nuovo Utente</h5>
                <div class="mb-3">
                    <input type="text" name="new_user_name" class="form-control" placeholder="Nome utente" required>
                </div>
                <div class="mb-3">
                    <input type="email" name="new_user_email" class="form-control" placeholder="Email utente" required>
                </div>
            </div>
            <div class="col-md-12 mb-3">
                <button type="button" class="btn btn-secondary" id="toggle_new_user">Inserisci Nuovo Utente</button>
            </div>

            <!-- Sezione: Dispositivi Disponibili -->
            <div class="col-md-12">
                <label class="form-label">Dispositivi disponibili</label>
                <select name="device_codes[]" class="form-select" multiple required style="height: 300px; overflow-y: auto; border-radius: 8px;">
                    <?php
                    $available = $conn->query("SELECT codice, numero_inventario, ubicazione 
                                               FROM device 
                                               WHERE stato = 'FUNZIONANTE' AND codice NOT IN (SELECT device_code FROM rentals WHERE rental_end IS NULL) 
                                               ORDER BY numero_inventario");
                    while ($d = $available->fetch_assoc()) {
                        echo "<option value='{$d['codice']}'>{$d['numero_inventario']} ({$d['ubicazione']})</option>";
                    }
                    ?>
                </select>
                <div class="form-text">Tieni premuto Ctrl (Cmd su Mac) per selezioni multiple</div>
            </div>

            <!-- Sezione: Firma Digitale -->
            <div class="col-md-12 mt-4">
                <h5>Firma Digitale</h5>
                <div id="signature-pad" style="border: 1px solid #ccc; width: 500px; height: 200px;"></div>
                <button type="button" class="btn btn-danger mt-2" id="clear-signature">Cancella Firma</button>
                <input type="hidden" name="signature" id="signature-data">
            </div>

            <!-- Bottone di invio -->
            <div class="col-12 mt-4">
                <button type="submit" name="add_rental_from_zero" class="btn btn-primary">Conferma Noleggio</button>
            </div>
        </form>
    </div>
</div>
<footer class="text-center py-3 height 50px fixed-bottom bg-white text-black">
    Realizzato per il <strong>Laboratorio Classroom Enrico Fermi</strong> da <strong>Ricchiuto Michele 4CI</strong>
</footer>
<script src="https://cdn.jsdelivr.net/npm/bootstrap @5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>