<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8" />
<title>Mappa Armadi - Tema Scuro Colonne con Popup e Auto Refresh</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
<style>
    /* Tema scuro base */
    body {
        background-color: #121212;
        color: #eee;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        margin: 20px 0;
    }
    h2, h4 {
        color: #f0f0f0;
        text-shadow: 0 0 5px rgba(255 255 255 / 0.1);
    }
    .container {
        width: 100%;
        margin: auto;
        padding: 0 30px;

        display: flex;
        justify-content: space-between;
        gap: 20px;
    }

    .column {
        width: 48%;
    }

    /* Stile armadio */
    .armadio {
        margin-top: 80px;
        margin-bottom: 40px;
        background: #1e1e1e;
        border-radius: 12px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.7);
        padding: 20px;
        position: relative;
    }

    table {
        border-collapse: separate;
        border-spacing: 6px;
        width: 100%;
        table-layout: fixed;
    }
    td {
        border-radius: 10px;
        height: 55px;
        font-weight: 700;
        font-size: 20px;
        text-align: center;
        vertical-align: middle;
        color: white;
        user-select: none;
        cursor: pointer;
        box-shadow:
            inset 0 -2px 4px rgba(0,0,0,0.4),
            0 3px 6px rgba(0,0,0,0.3);
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }
    td:hover {
        transform: scale(1.05);
        box-shadow:
            inset 0 -2px 6px rgba(0,0,0,0.6),
            0 6px 12px rgba(0,0,0,0.5);
    }

    /* Colori per stati */
    .bg-green {
        background-color: #28a745; /* verde */
        box-shadow: 0 0 8px #28a745cc;
    }
    .bg-blue {
        background-color: #0d6efd; /* azzurro */
        box-shadow: 0 0 8px #0d6efdcc;
    }
    .bg-orange {
        background-color: #fd7e14; /* arancione */
        animation: blinkorange 2s infinite;
        box-shadow: 0 0 10px #fd7e14cc;
    }
    /* Arancio lampeggiante */
    @keyframes blinkorange {
        0%, 100% { background-color: #fd7e14; }
        50% { background-color: #ffb84d; }
    }
    /* Rosso lampeggiante */
    @keyframes blinkred {
        0%, 100% { background-color: #dc3545; }
        50% { background-color: #ff6b6b; }
    }
    .bg-red-blink {
        animation: blinkred 1.5s infinite;
        color: white;
        box-shadow: 0 0 12px #dc3545cc;
    }

    /* Celle vuote */
    td:not(.bg-green):not(.bg-blue):not(.bg-orange):not(.bg-red-blink) {
        background-color: #2a2a2a;
        color: #666;
        box-shadow: inset 0 0 5px #000000aa;
    }
</style>
</head>
<body>

<div class="container" id="map-container">
    <!-- Mappa armadi caricata dinamicamente qui -->
</div>

<!-- Modal Bootstrap -->
<div class="modal fade" id="deviceModal" tabindex="-1" aria-labelledby="deviceModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered" style="max-width:90vw;">
    <div class="modal-content bg-dark text-white">
      <div class="modal-header">
        <h5 class="modal-title" id="deviceModalLabel">Dettagli dispositivo</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <div class="modal-body p-0" style="height: 80vh;">
        <iframe id="deviceIframe" src="" style="width: 100%; height: 100%; border: none;" sandbox="allow-same-origin allow-scripts allow-popups allow-forms"></iframe>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    const modal = new bootstrap.Modal(document.getElementById('deviceModal'));
    const iframe = document.getElementById('deviceIframe');
    const modalTitle = document.getElementById('deviceModalLabel');

    async function loadMap() {
        try {
            const response = await fetch('map_content.php');
            const html = await response.text();
            document.getElementById('map-container').innerHTML = html;

            // Riattiva click per popup
            document.querySelectorAll('td[data-codice]').forEach(td => {
                td.addEventListener('click', () => {
                    const codice = td.getAttribute('data-codice');
                    modalTitle.textContent = `Dettagli dispositivo: ${codice}`;
                    iframe.src = `http://ricchiuto.iliadboxos.it/NOLEGGI/device_history.php?codice=${encodeURIComponent(codice)}`;
                    modal.show();
                });
            });

        } catch (e) {
            console.error('Errore caricamento mappa:', e);
        }
    }

    loadMap();
    setInterval(loadMap, 10000);

    // Reset iframe src quando chiudi modale
    document.getElementById('deviceModal').addEventListener('hidden.bs.modal', () => {
        iframe.src = '';
    });
</script>
</body>
</html>
