<?php
include 'db.php';

// Recupera i dispositivi
$sql = "SELECT codice, numero_inventario, ubicazione, stato FROM device ORDER BY ubicazione, codice";
$result = $conn->query($sql);

$devices = [];
while ($row = $result->fetch_assoc()) {
    $parts = explode('.', $row['codice']);
    $armadio = $parts[0];
    $devices[$armadio][$row['codice']] = $row;
}

// Recupera dispositivi in noleggio
$inNoleggio = [];
$rentalSql = "SELECT device_code FROM rentals WHERE rental_end IS NULL";
$rentalResult = $conn->query($rentalSql);
while ($r = $rentalResult->fetch_assoc()) {
    $inNoleggio[$r['device_code']] = true;
}

function getPositionFromCode($codice) {
    $parts = explode('.', $codice);
    if (count($parts) < 2) return null;
    return intval($parts[1]);
}

function getDeviceState($armadio, $position, $devices, $inNoleggio) {
    if (!isset($devices[$armadio])) return null;

    foreach ($devices[$armadio] as $codice => $device) {
        if (getPositionFromCode($codice) === $position) {
            if (isset($inNoleggio[$codice])) {
                return 'IN_NOLEGGIO';
            }
            return $device['stato'];
        }
    }
    return null;
}

function getStateClass($state) {
    return match($state) {
        'FUNZIONANTE' => 'bg-green',
        'IN_NOLEGGIO' => 'bg-blue',
        'PARZIALE'    => 'bg-orange',
        'ROTTO'       => 'bg-red-blink',
        default       => '',
    };
}

$armadi_left = ['T_1', 'T_2'];
$armadi_right = ['L_3', 'L_4'];

echo '<div class="column" id="left-column">';
foreach ($armadi_left as $armadio) {
    echo "<div class='armadio'>";
    echo "<h4>Armadio $armadio</h4>";
    echo "<table>";
    echo "<tr>";
    for ($pos = 1; $pos <= 15; $pos++) {
        $state = getDeviceState($armadio, $pos, $devices, $inNoleggio);
        $class = getStateClass($state);
        $codice = $armadio . '.' . str_pad($pos, 2, '0', STR_PAD_LEFT);
        echo "<td class='$class' data-codice='$codice'>" . str_pad($pos, 2, '0', STR_PAD_LEFT) . "</td>";
    }
    echo "</tr>";
    echo "<tr>";
    for ($pos = 16; $pos <= 30; $pos++) {
        $state = getDeviceState($armadio, $pos, $devices, $inNoleggio);
        $class = getStateClass($state);
        $codice = $armadio . '.' . str_pad($pos, 2, '0', STR_PAD_LEFT);
        echo "<td class='$class' data-codice='$codice'>" . str_pad($pos, 2, '0', STR_PAD_LEFT) . "</td>";
    }
    echo "</tr>";
    echo "</table>";
    echo "</div>";
}
echo '</div>';

echo '<div class="column" id="right-column">';
foreach ($armadi_right as $armadio) {
    echo "<div class='armadio'>";
    echo "<h4>Armadio $armadio</h4>";
    echo "<table>";
    echo "<tr>";
    for ($pos = 1; $pos <= 15; $pos++) {
        $state = getDeviceState($armadio, $pos, $devices, $inNoleggio);
        $class = getStateClass($state);
        $codice = $armadio . '.' . str_pad($pos, 2, '0', STR_PAD_LEFT);
        echo "<td class='$class' data-codice='$codice'>" . str_pad($pos, 2, '0', STR_PAD_LEFT) . "</td>";
    }
    echo "</tr>";
    echo "<tr>";
    for ($pos = 16; $pos <= 30; $pos++) {
        $state = getDeviceState($armadio, $pos, $devices, $inNoleggio);
        $class = getStateClass($state);
        $codice = $armadio . '.' . str_pad($pos, 2, '0', STR_PAD_LEFT);
        echo "<td class='$class' data-codice='$codice'>" . str_pad($pos, 2, '0', STR_PAD_LEFT) . "</td>";
    }
    echo "</tr>";
    echo "</table>";
    echo "</div>";
}
echo '</div>';
?>
