<?php
if (isset($_GET['ajax'])) {
    $folder = __DIR__ . '/noleggi_pdf';
    $files = glob($folder . '/*.pdf');

    usort($files, function($a, $b) {
        return filemtime($b) - filemtime($a);
    });

    header('Content-Type: application/json');
    $response = [];

    foreach ($files as $file) {
        $filename = basename($file);
        $response[] = [
            'name' => $filename,
            'url' => 'noleggi_pdf/' . rawurlencode($filename),
            'date' => date("d/m/Y H:i", filemtime($file))
        ];
    }

    echo json_encode($response);
    exit;
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Elenco PDF noleggi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f0f2f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding-bottom: 60px;
        }
        .navbar-nav {
            flex-direction: row !important;
            flex-wrap: nowrap !important;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        .navbar-brand, .nav-link {
            color: black;
            font-weight: 600;
            cursor: pointer;
        }
        .nav-link:hover, .nav-link:focus {
            text-decoration: underline;
            color: #350050ff !important;
        }
        .nav-item {
            margin-right: 1rem;
        }
        .container {
            margin-top: 2rem;
            margin-bottom: 4rem;
            max-width: 1200px;
        }
        .pdf-entry {
            padding: 10px 15px;
            border-bottom: 1px solid #ddd;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: white;
            border-radius: 0.5rem;
            margin-bottom: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        }
        .pdf-info {
            display: flex;
            flex-direction: column;
        }
        .pdf-entry a {
            text-decoration: none;
            color: #0d6efd;
            font-weight: 500;
        }
        .date {
            color: #666;
            font-size: 0.9em;
        }
        .btn-print {
            margin-left: 10px;
        }
        footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: white;
            color: #555;
            font-size: 0.9rem;
            text-align: center;
            padding: 0.75rem 0;
            box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
            z-index: 1030;
        }
        @media (max-width: 768px) {
            .nav-item {
                margin-bottom: 0;
            }
            .navbar-nav {
                flex-direction: row;
                flex-wrap: wrap;
                justify-content: center;
            }
            .nav-item {
                margin-right: 0.75rem;
                margin-bottom: 0.5rem;
            }
            .nav-link {
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm px-4">
    <a class="navbar-brand" href="#">PDF Noleggi</a>
    <div class="collapse navbar-collapse">
        <ul class="navbar-nav ms-auto">
            <li class="nav-item"><a class="nav-link" onclick="location.href='index.php'">Indietro</a></li>
        </ul>
    </div>
</nav>

<div class="container">
    <h2 class="mb-4">PDF Noleggi più recenti</h2>
    <div id="pdf-list">
        <div class="alert alert-info">Caricamento in corso...</div>
    </div>
</div>

<footer>
    © <?= date('Y') ?> Laboratorio Classroom. Tutti i diritti riservati.
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function loadPDFs() {
    fetch('?ajax=1')
        .then(response => response.json())
        .then(data => {
            const container = document.getElementById('pdf-list');
            container.innerHTML = '';

            if (data.length === 0) {
                container.innerHTML = '<div class="alert alert-info">Nessun file trovato nella cartella dei noleggi.</div>';
                return;
            }

            data.forEach(pdf => {
                const entry = document.createElement('div');
                entry.className = 'pdf-entry';

                entry.innerHTML = `
                    <div class="pdf-info">
                        <a href="${pdf.url}" target="_blank">📄 ${pdf.name}</a>
                        <span class="date">${pdf.date}</span>
                    </div>
                    <button class="btn btn-sm btn-outline-primary btn-print" onclick="printPDF('${pdf.url}')">Stampa</button>
                `;

                container.appendChild(entry);
            });
        })
        .catch(error => {
            document.getElementById('pdf-list').innerHTML = '<div class="alert alert-danger">Errore nel caricamento dei PDF.</div>';
            console.error('Errore:', error);
        });
}

function printPDF(url) {
    const printWindow = window.open(url, '_blank');
    printWindow.onload = function() {
        printWindow.focus();
        printWindow.print();
    };
}

// Caricamento iniziale e aggiornamento ogni 3 secondi
loadPDFs();
setInterval(loadPDFs, 3000);
</script>
</body>
</html>
