<?php
include 'db.php';

// Gestione POST per inserimenti e aggiornamenti (resta invariato, come da tuo codice)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['add_rental'])) {
        $user_id = $_POST['user_id'];
        $device_codes = $_POST['device_codes'];
        $start = date('Y-m-d H:i:s');

        foreach ($device_codes as $code) {
            $stmt = $conn->prepare("SELECT codice FROM device WHERE codice = ? LIMIT 1");
            if (!$stmt) die("Errore nella prepare: " . $conn->error);
            $stmt->bind_param("s", $code);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result && $result->num_rows > 0) {
                $row = $result->fetch_assoc();
                $device_code = $row['codice'];

                $stmt2 = $conn->prepare("INSERT INTO rentals (device_code, user_id, rental_start) VALUES (?, ?, ?)");
                if (!$stmt2) die("Errore nella prepare insert: " . $conn->error);
                $stmt2->bind_param("sis", $device_code, $user_id, $start);
                $stmt2->execute();
                $stmt2->close();
            } else {
                echo "<p>Errore: Dispositivo con codice '$code' non trovato.</p>";
            }
            $stmt->close();
        }
        header("Location: index.php");
        exit();
    }

    if (isset($_POST['return_rental'])) {
        $rental_id = $_POST['rental_id'];
        $end = date('Y-m-d H:i:s');
        $stmt = $conn->prepare("UPDATE rentals SET rental_end = ? WHERE id = ?");
        if (!$stmt) die("Errore update: " . $conn->error);
        $stmt->bind_param("si", $end, $rental_id);
        $stmt->execute();
        $stmt->close();
        header("Location: index.php");
        exit();
    }

    if (isset($_POST['add_user'])) {
        $name = $_POST['new_user_name'];
        $email = $_POST['new_user_email'];
        $stmt = $conn->prepare("INSERT INTO users (name, email) VALUES (?, ?)");
        if (!$stmt) die("Errore insert utente: " . $conn->error);
        $stmt->bind_param("ss", $name, $email);
        $stmt->execute();
        $stmt->close();
        header("Location: index.php");
        exit();
    }

    if (isset($_POST['add_device'])) {
        $codice = $_POST['new_device_code'];
        $numero_inventario = $_POST['new_device_inventory'];
        $ubicazione = $_POST['new_device_location'];
        $stato = $_POST['new_device_status'];

        $stmt = $conn->prepare("INSERT INTO device (codice, numero_inventario, ubicazione, stato) VALUES (?, ?, ?, ?)");
        if (!$stmt) die("Errore insert dispositivo: " . $conn->error);
        $stmt->bind_param("ssss", $codice, $numero_inventario, $ubicazione, $stato);
        $stmt->execute();
        $stmt->close();
        header("Location: index.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Gestione Noleggi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <style>
        /* Corpo pagina */
        body {
            background-color: #f0f2f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding-bottom: 60px; /* spazio per footer fisso */
        }

        /* Navbar - forza sempre il menu in orizzontale */
        .navbar-nav {
            flex-direction: row !important;  /* riga sempre */
            flex-wrap: nowrap !important;    /* NO ritorno a capo */
            overflow-x: auto;                /* scroll orizzontale se troppo lungo */
            -webkit-overflow-scrolling: touch; /* smooth scroll su mobile */

        }
        .navbar-brand, .nav-link {
            color: black;
            font-weight: 600;
            cursor: pointer;

        }
        .nav-link:hover, .nav-link:focus {
            text-decoration: underline;
            color: #350050ff !important;
        }
        /* Spaziatura tra i link */
        .nav-item {
            margin-right: 1rem;
        }

        /* Container principale */
        .container {
            margin-top: 2rem;
            margin-bottom: 4rem;
            max-width: 1200px;
        }

        /* Card personalizzate */
        .card {
            border-radius: 1rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border: none;
        }

        /* Tabelle */
        table {
            border-radius: 0.625rem;
            overflow: hidden;
        }

        /* Bottoni */
        .btn-primary {
            background-color: #4e54c8;
            border: none;
        }
        .btn-primary:hover, .btn-primary:focus {
            background-color: #3b3fc0;
            box-shadow: 0 0 8px rgba(59,63,192,0.7);
        }
        .btn-success {
            background-color: #198754;
            border: none;
        }
        .btn-success:hover, .btn-success:focus {
            background-color: #157347;
            box-shadow: 0 0 8px rgba(21,115,71,0.7);
        }
        .btn-danger {
            background-color: #dc3545;
            border: none;
        }
        .btn-danger:hover, .btn-danger:focus {
            background-color: #b02a37;
            box-shadow: 0 0 8px rgba(176,42,55,0.7);
        }

        /* Footer fisso in basso */
        footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: white;
            color: #555;
            font-size: 0.9rem;
            text-align: center;
            padding: 0.75rem 0;
            box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
            z-index: 1030;
        }

        /* Sezioni nascoste */
        .section {
            display: none;
        }

        /* Rimuovi margine inferiore per mobile */
        @media (max-width: 768px) {
            .nav-item {
                margin-bottom: 0;
            }
        }

        /* Responsive Navbar e layout */
        @media (max-width: 768px) {
            .navbar-nav {
                flex-direction: row;
                flex-wrap: wrap;
                justify-content: center;
            }
            .nav-item {
                margin-right: 0.75rem;
                margin-bottom: 0.5rem;
            }
            .nav-link {
                font-size: 0.9rem;
            }
        }
    </style>
    <script>
        function showSection(id) {
            document.querySelectorAll('.section').forEach(s => s.style.display = 'none');
            document.getElementById(id).style.display = 'block';
        }
        window.onload = () => showSection('noleggi');
    </script>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
        <a class="navbar-brand" href="#">Gestione Noleggi</a>
        <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
            <li class="nav-item"><a class="nav-link" onclick="showSection('noleggi')">Noleggi Attivi</a></li>
            <li class="nav-item"><a class="nav-link" onclick="location.href='noleggi.php'">Nuovo Noleggio</a></li>
            <li class="nav-item"><a class="nav-link" onclick="showSection('storico_utente')">Storico Utente</a></li>
            <li class="nav-item"><a class="nav-link" onclick="showSection('storico_dispositivo')">Storico Dispositivo</a></li>
            <li class="nav-item"><a class="nav-link" onclick="showSection('aggiungi')">Gestione Dati</a></li>
            <li class="nav-item"><a class="nav-link" onclick="location.href='chiudi.php'">Chiusura email</a></li>
            <li class="nav-item"><a class="nav-link" onclick="location.href='indexpdf.php'">PDF Noleggi</a></li>
            <!-- <li class="nav-item"><a class="nav-link" onclick="showSection('nuovo_noleggio')">Nuovo Noleggio</a></li> -->
        </ul>
    </div>
</nav>


<div class="container">

    <!-- Noleggi Attivi -->
    <div id="noleggi" class="section">
        <div class="card p-4">
            <h3 class="mb-3">Noleggi Attivi</h3>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Codice</th>
                            <th>Numero Inventario</th>
                            <th>Ubicazione</th>
                            <th>Utente</th>
                            <th>Inizio</th>
                            <th>Azione</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sql = "SELECT rentals.id AS rental_id, device.codice, device.numero_inventario, device.ubicazione, users.name, rentals.rental_start 
                                FROM rentals 
                                JOIN device ON rentals.device_code = device.codice 
                                JOIN users ON rentals.user_id = users.id 
                                WHERE rentals.rental_end IS NULL";
                        $result = $conn->query($sql);
                        while ($row = $result->fetch_assoc()) {
                            echo "<tr>
                                <td>{$row['rental_id']}</td>
                                <td>{$row['codice']}</td>
                                <td>{$row['numero_inventario']}</td>
                                <td>{$row['ubicazione']}</td>
                                <td>{$row['name']}</td>
                                <td>{$row['rental_start']}</td>
                                <td>
                                    <form method='post' onsubmit=\"return confirm('Sei sicuro di voler restituire questo dispositivo?');\">
                                        <input type='hidden' name='rental_id' value='{$row['rental_id']}'>
                                        <button class='btn btn-sm btn-danger' type='submit' name='return_rental'>Restituisci</button>
                                    </form>
                                </td>
                            </tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Nuovo Noleggio -->
    <div id="nuovo_noleggio" class="section">
        <div class="card p-4">
            <h3>Nuovo Noleggio</h3>
            <form method="post" class="row g-3">
                <div class="col-md-6">
                    <label for="user_id" class="form-label">Utente</label>
                    <select id="user_id" name="user_id" class="form-select" required>
                        <option value="">Seleziona utente</option>
                        <?php
                        $users = $conn->query("SELECT id, name FROM users ORDER BY name");
                        while ($u = $users->fetch_assoc()) {
                            echo "<option value='{$u['id']}'>" . htmlspecialchars($u['name']) . "</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="device_codes" class="form-label">Dispositivi disponibili</label>
                    <select id="device_codes" name="device_codes[]" class="form-select" multiple required size="10" style="border-radius: 0.5rem;">
                        <?php
                        $available = $conn->query("SELECT codice, numero_inventario, ubicazione 
                                                   FROM device 
                                                   WHERE stato = 'FUNZIONANTE' AND codice NOT IN (SELECT device_code FROM rentals WHERE rental_end IS NULL) 
                                                   ORDER BY numero_inventario");
                        while ($d = $available->fetch_assoc()) {
                            echo "<option value='" . htmlspecialchars($d['codice']) . "'>" 
                                . htmlspecialchars($d['codice']) . " - " 
                                . htmlspecialchars($d['numero_inventario']) . " (" 
                                . htmlspecialchars($d['ubicazione']) . ")</option>";
                        }
                        ?>
                    </select>
                    <div class="form-text">Tieni premuto Ctrl (Cmd su Mac) per selezioni multiple</div>
                </div>
                <div class="col-12">
                    <button type="submit" name="add_rental" class="btn btn-primary">Conferma Noleggio</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Storico Utente -->
    <div id="storico_utente" class="section">
        <div class="card p-4">
            <h3>Storico Utente</h3>
            <form method="get" action="user_history.php" class="row g-3">
                <div class="col-md-10">
                    <input type="email" name="email" class="form-control" placeholder="Email utente" required>
                </div>
                <div class="col-md-2 d-grid">
                    <button type="submit" class="btn btn-primary">Cerca</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Storico Dispositivo -->
    <div id="storico_dispositivo" class="section">
        <div class="card p-4">
            <h3>Storico Dispositivo</h3>
            <form method="get" action="device_history.php" class="row g-3">
                <div class="col-md-6">
                    <input type="text" name="codice" class="form-control" placeholder="Codice dispositivo (es. T_1.01)" required>
                </div>
                <div class="col-md-6 d-grid">
                    <button type="submit" class="btn btn-primary">Cerca</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Gestione Dati -->
    <div id="aggiungi" class="section">
        <div class="card p-4 mb-4">
            <h3>Aggiungi Nuovo Utente</h3>
            <form method="post" class="row g-3">
                <div class="col-md-6">
                    <input type="text" name="new_user_name" class="form-control" placeholder="Nome utente" required>
                </div>
                <div class="col-md-6">
                    <input type="email" name="new_user_email" class="form-control" placeholder="Email utente" required>
                </div>
                <div class="col-12 d-grid">
                    <button type="submit" name="add_user" class="btn btn-success">Aggiungi Utente</button>
                </div>
            </form>
        </div>

        <div class="card p-4">
            <h3>Aggiungi Nuovo Dispositivo</h3>
            <form method="post" class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="new_device_code" class="form-control" placeholder="Codice (es. T_1.01)" required>
                </div>
                <div class="col-md-3">
                    <input type="text" name="new_device_inventory" class="form-control" placeholder="Numero inventario" required>
                </div>
                <div class="col-md-3">
                    <input type="text" name="new_device_location" class="form-control" placeholder="Ubicazione" required>
                </div>
                <div class="col-md-3">
                    <select name="new_device_status" class="form-select" required>
                        <option value="" disabled selected>Stato</option>
                        <option value="FUNZIONANTE">FUNZIONANTE</option>
                        <option value="PARZIALE">PARZIALE</option>
                        <option value="ROTTO">ROTTO</option>
                    </select>
                </div>
                <div class="col-12 d-grid">
                    <button type="submit" name="add_device" class="btn btn-success">Aggiungi Dispositivo</button>
                </div>
            </form>
        </div>
    </div>
</div>

<footer>
    Realizzato per il <strong>Laboratorio Classroom Enrico Fermi</strong> da <strong>Ricchiuto Michele 4CI</strong>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
