<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Storico Dispositivo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap @5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { padding: 20px; background-color: #f8f9fa; }
        table { margin-top: 20px; }
        h1 { margin-bottom: 30px; }
    </style>
</head>
<body>
<div class="container">
    <h1>Storico Noleggi del Dispositivo</h1>
    <?php
    if (!isset($_GET['codice'])) {
        echo "<div class='alert alert-danger'>Codice dispositivo non fornito.</div>";
        exit();
    }

    $codice = $_GET['codice'];

    // Query per ottenere lo storico del dispositivo
    $stmt = $conn->prepare("SELECT r.id AS rental_id, u.name, u.email, r.rental_start, r.rental_end 
                            FROM rentals r
                            JOIN device d ON r.device_code = d.codice
                            JOIN users u ON r.user_id = u.id
                            WHERE d.codice = ?");

    if (!$stmt) {
        die("Errore nella preparazione della query: " . $conn->error);
    }

    $stmt->bind_param("s", $codice);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo "<table class='table table-bordered table-striped'>
                <thead class='table-light'>
                <tr>
                    <th>ID Noleggio</th><th>Utente</th><th>Email</th><th>Inizio</th><th>Fine</th>
                </tr>
                </thead>
                <tbody>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>
                    <td>{$row['rental_id']}</td>
                    <td>{$row['name']}</td>
                    <td>{$row['email']}</td>
                    <td>{$row['rental_start']}</td>
                    <td>" . ($row['rental_end'] ? $row['rental_end'] : '<span class="text-danger">Ancora attivo</span>') . "</td>
                  </tr>";
        }
        echo "</tbody></table>";
    } else {
        echo "<div class='alert alert-warning'>Nessun noleggio trovato per questo dispositivo.</div>";
    }
    ?>
    <a href="index.php" class="btn btn-secondary mt-3">⬅ Torna alla Home</a>
</div>
</body>
</html>