<?php
include 'db.php';
require 'vendor/autoload.php'; // PHPMailer
require('fpdf/fpdf.php');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['close_rentals'])) {
    $rental_ids = $_POST['rental_ids'] ?? [];
    if (empty($rental_ids)) {
        die("Nessun noleggio selezionato.");
    }

    $rental_placeholders = implode(',', array_fill(0, count($rental_ids), '?'));
    $types = str_repeat('i', count($rental_ids));

    // Recupera info utente + dispositivi prima di chiudere
    $query = "SELECT rentals.id, rentals.device_code, users.name, users.email, device.numero_inventario
              FROM rentals 
              JOIN users ON rentals.user_id = users.id
              JOIN device ON rentals.device_code = device.codice
              WHERE rentals.id IN ($rental_placeholders)";

    $stmt = $conn->prepare($query);
    $stmt->bind_param($types, ...$rental_ids);
    $stmt->execute();
    $result = $stmt->get_result();

    $devices = [];
    $user_name = $user_email = '';
    while ($row = $result->fetch_assoc()) {
        $devices[] = [
            'id' => $row['id'],
            'code' => $row['device_code'],
            'inv' => $row['numero_inventario']
        ];
        $user_name = $row['name'];
        $user_email = $row['email'];
    }
    $stmt->close();

    // Chiude i noleggi
    $now = date('Y-m-d H:i:s');
    $update = $conn->prepare("UPDATE rentals SET rental_end = ? WHERE id = ?");
    foreach ($rental_ids as $id) {
        $update->bind_param("si", $now, $id);
        $update->execute();
    }
    $update->close();

    // Genera PDF
    class PDF extends FPDF {
        function Header() {
            if (file_exists('fermi.png')) {
                $this->Image('fermi.png', 0, 0, 210);
                $this->Ln(35);
            }
            $this->SetFont('Arial', 'B', 14);
            $this->Cell(0, 10, 'Conferma Restituzione Dispositivi', 0, 1, 'C');
            $this->Ln(10);
        }
        function Footer() {
            $this->SetY(-15);
            $this->SetFont('Arial', 'I', 8);
            $this->Cell(0, 10, 'Pagina ' . $this->PageNo() . '/{nb}', 0, 1, 'C');
            $this->SetFont('Arial', '', 6);
            $this->Cell(0, 5, 'Realizzato da RICCHIUTO Michele 4CI. Tutti i diritti riservati', 0, 0, 'C');
        }
    }

    $pdf = new PDF();
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf->SetFont('Arial', '', 12);

    $pdf->Cell(0, 10, "Nome utente: $user_name", 0, 1);
    $pdf->Cell(0, 10, "Email: $user_email", 0, 1);
    $pdf->Cell(0, 10, "Data restituzione: $now", 0, 1);
    $pdf->Ln(5);

    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(30, 10, 'ID', 1);
    $pdf->Cell(60, 10, 'Codice', 1);
    $pdf->Cell(60, 10, 'Inventario', 1);
    $pdf->Ln();

    $pdf->SetFont('Arial', '', 12);
    foreach ($devices as $dev) {
        $pdf->Cell(30, 10, $dev['id'], 1);
        $pdf->Cell(60, 10, $dev['code'], 1);
        $pdf->Cell(60, 10, $dev['inv'], 1);
        $pdf->Ln();
    }

    if (!is_dir('restituzioni_pdf')) {
        mkdir('restituzioni_pdf', 0777, true);
    }

    $safe_email = strtolower(preg_replace("/[^a-zA-Z0-9]+/", "_", $user_email));
    $safe_name = strtolower(preg_replace("/[^a-zA-Z0-9]+/", "_", $user_name));
    $main_rental_id = $rental_ids[0];
    $pdf_name = "restituzione_{$safe_email}_{$safe_name}_{$main_rental_id}.pdf";
    $pdf_path = "restituzioni_pdf/$pdf_name";
    $pdf->Output('F', $pdf_path);

    // Invia email
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'ricchiutomichele8@gmail.com';
        $mail->Password = 'pdnt jsyi wipd trxb';
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        $mail->setFrom('TUAEMAIL@gmail.com', 'Laboratorio Classroom');
        $mail->addAddress($user_email);
        $mail->addCC('visori@fermilecce.edu.it');
        $mail->Subject = 'Restituzione dispositivi - Conferma';
        $mail->Body = "Gentile $user_name,\n\nIn allegato trova il riepilogo della restituzione dei dispositivi.\n\nID: $main_rental_id \n\nCordiali saluti. \nLaboratorio Classroom.";
        $mail->addAttachment($pdf_path);
        $mail->send();
    } catch (Exception $e) {
        echo "Errore invio email: {$mail->ErrorInfo}";
    }

    echo "<div style='padding:20px;font-family:sans-serif;'>Restituzione completata! <a href='$pdf_path' target='_blank'>Scarica PDF</a></div>";
}
?>

<!DOCTYPE html>
<html lang="it">
    <style> 
    .nav-link-top-right {
    color: black;
    font-weight: 600;
    text-decoration: none;
    transition: color 0.3s;
}

.nav-link-top-right:hover {
    text-decoration: underline;
    color: #350050ff;
}



    </style>
<head>
    <meta charset="UTF-8">
    <title>Restituzione Dispositivi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="d-flex justify-content-end px-4 pt-3">
    <a href="index.php" class="nav-link-top-right">indietro</a>
</div>

<div class="container py-4">
    <h2 class="mb-4">Chiudi Noleggi</h2>
    <form method="POST">
        <table class="table table-bordered table-hover">
            <thead class="table-dark">
                <tr>
                    <th>Seleziona</th>
                    <th>ID</th>
                    <th>Codice Dispositivo</th>
                    <th>Inventario</th>
                    <th>Email</th>
                    <th>Inizio</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $res = $conn->query("SELECT rentals.id, device_code, numero_inventario, rental_start, email FROM rentals JOIN device ON device.codice = rentals.device_code JOIN users ON rentals.user_id = users.id WHERE rental_end IS NULL");
                while ($r = $res->fetch_assoc()): ?>
                    <tr>
                        <td><input type="checkbox" name="rental_ids[]" value="<?= $r['id'] ?>"></td>
                        <td><?= $r['id'] ?></td>
                        <td><?= htmlspecialchars($r['device_code']) ?></td>
                        <td><?= htmlspecialchars($r['numero_inventario']) ?></td>
                        <td><?= htmlspecialchars($r['email']) ?></td>
                        <td><?= $r['rental_start'] ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        <button type="submit" name="close_rentals" class="btn btn-success">Chiudi Noleggi Selezionati</button>
    </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
